/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mat.internal.snapshot.inspections.CompareTablesQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;

public class CompareTablesPane
extends QueryResultPane {
    private DiffOption diffOption;

    public void initWithArgument(Object argument) {
        super.initWithArgument(argument);
        IResult subject = ((QueryResult)argument).getSubject();
        if (subject instanceof CompareTablesQuery.TableComparisonResult) {
            CompareTablesQuery.Mode mode = ((CompareTablesQuery.TableComparisonResult)subject).getMode();
            switch (mode) {
                case ABSOLUTE: {
                    this.diffOption = DiffOption.ABSOLUTE;
                    break;
                }
                case DIFF_TO_FIRST: {
                    this.diffOption = DiffOption.DIFF_TO_BASE;
                    break;
                }
                case DIFF_TO_PREVIOUS: {
                    this.diffOption = DiffOption.DIFF_TO_PREV;
                    break;
                }
                case DIFF_RATIO_TO_FIRST: {
                    this.diffOption = DiffOption.DIFF_RATIO_TO_BASE;
                    break;
                }
                case DIFF_RATIO_TO_PREVIOUS: {
                    this.diffOption = DiffOption.DIFF_RATIO_TO_PREV;
                    break;
                }
            }
        }
    }

    public void contributeToToolBar(IToolBarManager manager) {
        this.addDiffOptions(manager);
        this.addSelectColumns(manager);
        manager.add((IContributionItem)new Separator());
        super.contributeToToolBar(manager);
    }

    private void addSelectColumns(IToolBarManager manager) {
        final IResult result = this.viewer.getQueryResult().getSubject();
        if (result instanceof CompareTablesQuery.TableComparisonResult) {
            EasyToolBarDropDown selectColumnsAction = new EasyToolBarDropDown(Messages.CompareTablesPane_SelectDisplayedColumnsTooltip, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/select_table.gif"), this){

                public void contribute(PopupMenu menu) {
                    List columns = ((CompareTablesQuery.TableComparisonResult)result).getComparedColumns();
                    for (CompareTablesQuery.ComparedColumn comparedColumn : columns) {
                        menu.add(new SelectColumnAction(comparedColumn));
                    }
                }
            };
            manager.add((IAction)selectColumnsAction);
        }
    }

    private void addDiffOptions(IToolBarManager manager) {
        EasyToolBarDropDown diffOptionAction = new EasyToolBarDropDown(Messages.CompareTablesPane_ChooseDiffOptionTooltip, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/grouping.gif"), this){

            public void contribute(PopupMenu menu) {
                DiffOption[] diffOptionArray = DiffOption.values();
                int n = diffOptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DiffOption opt = diffOptionArray[n2];
                    DiffOptionAction action = new DiffOptionAction(opt);
                    action.setEnabled(opt != CompareTablesPane.this.diffOption);
                    action.setChecked(opt == CompareTablesPane.this.diffOption);
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)diffOptionAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffOption {
        ABSOLUTE(Messages.CompareTablesPane_AbsoluteValues),
        DIFF_TO_BASE(Messages.CompareTablesPane_DifferenceToBaseTable),
        DIFF_RATIO_TO_BASE(Messages.CompareTablesPane_PercentageDifferenceToBaseTable),
        DIFF_TO_PREV(Messages.CompareTablesPane_DifferenceToPrecedingTable),
        DIFF_RATIO_TO_PREV(Messages.CompareTablesPane_PercentageDifferenceToPrecedingTable);

        String label;

        private DiffOption(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class DiffOptionAction
    extends Action {
        private DiffOption diffOption;

        private DiffOptionAction(DiffOption diffOption) {
            super(diffOption.toString(), 2);
            this.diffOption = diffOption;
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            CompareTablesQuery.Mode mode = CompareTablesQuery.Mode.ABSOLUTE;
            switch (this.diffOption) {
                case DIFF_TO_PREV: {
                    mode = CompareTablesQuery.Mode.DIFF_TO_PREVIOUS;
                    break;
                }
                case DIFF_TO_BASE: {
                    mode = CompareTablesQuery.Mode.DIFF_TO_FIRST;
                    break;
                }
                case DIFF_RATIO_TO_PREV: {
                    mode = CompareTablesQuery.Mode.DIFF_RATIO_TO_PREVIOUS;
                    break;
                }
                case DIFF_RATIO_TO_BASE: {
                    mode = CompareTablesQuery.Mode.DIFF_RATIO_TO_FIRST;
                    break;
                }
            }
            IResult result = CompareTablesPane.this.viewer.getQueryResult().getSubject();
            if (result instanceof CompareTablesQuery.TableComparisonResult) {
                ((CompareTablesQuery.TableComparisonResult)result).setMode(mode);
            }
            final QueryResult queryResult = new QueryResult(null, "compare", result);
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    CompareTablesPane.this.top.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            CompareTablesPane.this.diffOption = DiffOptionAction.this.diffOption;
                            CompareTablesPane.this.deactivateViewer();
                            RefinedResultViewer v = CompareTablesPane.this.createViewer(queryResult);
                            CompareTablesPane.this.activateViewer(v);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private class SelectColumnAction
    extends Action {
        CompareTablesQuery.ComparedColumn column;

        public SelectColumnAction(CompareTablesQuery.ComparedColumn column) {
            super(column.getDescription().getLabel(), 2);
            this.column = column;
            this.setChecked(column.isDisplayed());
        }

        public void run() {
            this.column.setDisplayed(!this.column.isDisplayed());
            IResult result = CompareTablesPane.this.viewer.getQueryResult().getSubject();
            if (result instanceof CompareTablesQuery.TableComparisonResult) {
                ((CompareTablesQuery.TableComparisonResult)result).updateColumns();
            }
            final QueryResult queryResult = new QueryResult(null, "compare", result);
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    CompareTablesPane.this.top.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            CompareTablesPane.this.deactivateViewer();
                            RefinedResultViewer v = CompareTablesPane.this.createViewer(queryResult);
                            CompareTablesPane.this.activateViewer(v);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

