/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tests.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class UrlBuilder {
    private final StringBuilder buf = new StringBuilder(512);

    private UrlBuilder() {
    }

    public static UrlBuilder build(TaskRepository repository) {
        UrlBuilder builder = new UrlBuilder();
        String url = repository.getRepositoryUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return builder.append(url);
    }

    public UrlBuilder append(String urlSegment) {
        this.buf.append(urlSegment);
        return this;
    }

    public UrlBuilder parameter(String name, Object value) {
        return this.parameter(name, value == null ? null : value.toString());
    }

    public UrlBuilder parameter(String name, String value) {
        int indexOfQ = this.buf.indexOf("?");
        if (indexOfQ == -1) {
            this.buf.append("?");
        } else {
            this.buf.append("&");
        }
        this.buf.append(name);
        this.buf.append('=');
        if (value != null) {
            this.buf.append(this.encode(value));
        }
        return this;
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.buf.toString();
    }
}

