/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.net4j.internal.util.table.Cell;
import org.eclipse.net4j.internal.util.table.ComposedRange;
import org.eclipse.net4j.internal.util.table.Coordinate;
import org.eclipse.net4j.internal.util.table.OffsetRange;
import org.eclipse.net4j.internal.util.table.Range;
import org.eclipse.net4j.internal.util.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRange
implements Range {
    @Override
    public abstract Table table();

    @Override
    public abstract Iterator<Cell> iterator();

    @Override
    public Set<Cell> set() {
        HashSet<Cell> set = new HashSet<Cell>();
        this.fillCells(set);
        return set;
    }

    @Override
    public List<Cell> list() {
        ArrayList<Cell> list = new ArrayList<Cell>();
        this.fillCells(list);
        return list;
    }

    @Override
    public int accept(Cell.Visitor visitor) throws Exception {
        int n = 0;
        for (Cell cell : this) {
            if (!visitor.visit(cell, n++)) break;
        }
        return n;
    }

    @Override
    public boolean contains(int col, int row) {
        for (Cell cell : this) {
            if (cell.col != col || cell.row != row) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Coordinate coordinate) {
        return this.contains(coordinate.col, coordinate.row);
    }

    @Override
    public boolean contains(Cell cell) {
        return this.contains(cell.col, cell.row);
    }

    @Override
    public boolean contains(Range range) {
        for (Cell cell : range) {
            if (this.contains(cell)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Range offset(int cols, int rows) {
        return new OffsetRange(this, cols, rows);
    }

    @Override
    public Range addRange(Coordinate coordinate1, Coordinate coordinate2) {
        return this.addRanges(this.table().range(coordinate1, coordinate2));
    }

    @Override
    public Range addRange(int col1, int row1, int col2, int row2) {
        return this.addRange(new Coordinate(col1, row1), new Coordinate(col2, row2));
    }

    @Override
    public Range addRanges(Range ... ranges) {
        ComposedRange result = new ComposedRange(this.table(), this);
        return result.addRanges(ranges);
    }

    @Override
    public Range subtractRange(Coordinate coordinate1, Coordinate coordinate2) {
        return this.subtractRanges(this.table().range(coordinate1, coordinate2));
    }

    @Override
    public Range subtractRange(int col1, int row1, int col2, int row2) {
        return this.subtractRange(new Coordinate(col1, row1), new Coordinate(col2, row2));
    }

    @Override
    public Range subtractRanges(Range ... ranges) {
        ComposedRange result = new ComposedRange(this.table(), this);
        return result.subtractRanges(ranges);
    }

    @Override
    public Range value(Object value) {
        for (Cell cell : this) {
            cell.value(value);
        }
        return this;
    }

    @Override
    public Range format(Format format) {
        for (Cell cell : this) {
            cell.format(format);
        }
        return this;
    }

    @Override
    public Range alignment(Range.Alignment alignment) {
        for (Cell cell : this) {
            cell.alignment(alignment);
        }
        return this;
    }

    public int hashCode() {
        return this.set().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.set().equals(other.set());
    }

    private void fillCells(Collection<Cell> cells) {
        for (Cell cell : this) {
            cells.add(cell);
        }
    }
}

