/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.widget;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.messages.Messages;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DiagramPreferencesDefaultButton
extends Composite {
    private Button button;
    private SelectionListener listener;
    protected DataSource input;

    public DiagramPreferencesDefaultButton(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.createButton();
    }

    protected void createButton() {
        this.button = new Button((Composite)this, 0);
        this.button.setText(Messages.DiagramPreferencesDefaultButton_ResetDefault);
        this.listener = this.createListener();
        this.button.addSelectionListener(this.listener);
    }

    public void setInput(DataSource input) {
        this.input = input;
    }

    public DataSource getInput() {
        return this.input;
    }

    private SelectionListener createListener() {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramPreferencesDefaultButton.this.resetProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return listener;
    }

    public void dispose() {
        super.dispose();
        this.button.removeSelectionListener(this.listener);
        this.input = null;
    }

    protected void resetProperties() {
        IPreferenceStore globalPreferenceStore = Activator.getDefault().getPreferenceStore();
        String diagramType = this.getDiagramType();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            int rulerUnitsStyle;
            int rulerUnitsPref;
            boolean snapToGeometryStyle;
            boolean snapToGeometryPref;
            boolean snapToGridStyle;
            boolean snapToGridPref;
            double gridSpacingStyle;
            double gridSpacingPref;
            int gridLineStyle;
            int gridLinePref;
            int gridColorStyle;
            int gridColorPref;
            boolean gridOrderStyle;
            boolean gridOrderPref;
            boolean viewRulersStyle;
            boolean viewRulersPref;
            boolean viewGridStyle;
            CompoundCommand compoundCommand = new CompoundCommand(diagramType);
            boolean viewGridPref = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)24));
            if (viewGridPref != (viewGridStyle = NotationUtils.getBooleanValue((View)diagram, (String)"rulergrid.viewgrid", (boolean)viewGridPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)viewGridPref, NotationPackage.eINSTANCE.getBooleanValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), "rulergrid.viewgrid");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((viewRulersPref = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)23))) != (viewRulersStyle = NotationUtils.getBooleanValue((View)diagram, (String)"rulergrid.viewrulers", (boolean)viewRulersPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)viewRulersPref, NotationPackage.eINSTANCE.getBooleanValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), "rulergrid.viewrulers");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((gridOrderPref = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)30))) != (gridOrderStyle = NotationUtils.getBooleanValue((View)diagram, (String)"rulergrid.gridlevel", (boolean)gridOrderPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)gridOrderPref, NotationPackage.eINSTANCE.getBooleanValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), "rulergrid.gridlevel");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((gridColorPref = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)globalPreferenceStore, (String)PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)28))).intValue()) - (gridColorStyle = NotationUtils.getIntValue((View)diagram, (String)"rulergrid.gridlinecolor", (int)gridColorPref)) != 0) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)gridColorPref, NotationPackage.eINSTANCE.getIntValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getIntValueStyle_IntValue(), "rulergrid.gridlinecolor");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((gridLinePref = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)31))) - (gridLineStyle = NotationUtils.getIntValue((View)diagram, (String)"rulergrid.gridlinestyle", (int)gridLinePref)) != 0) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)gridLinePref, NotationPackage.eINSTANCE.getIntValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getIntValueStyle_IntValue(), "rulergrid.gridlinestyle");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((gridSpacingPref = globalPreferenceStore.getDouble(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)29))) != (gridSpacingStyle = NotationUtils.getDoubleValue((View)diagram, (String)"rulergrid.gridspacing", (double)gridSpacingPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)gridSpacingPref, NotationPackage.eINSTANCE.getDoubleValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getDoubleValueStyle_DoubleValue(), "rulergrid.gridspacing");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((snapToGridPref = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)26))) != (snapToGridStyle = NotationUtils.getBooleanValue((View)diagram, (String)"rulergrid.snaptogrid", (boolean)snapToGridPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)snapToGridPref, NotationPackage.eINSTANCE.getBooleanValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), "rulergrid.snaptogrid");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((snapToGeometryPref = globalPreferenceStore.getBoolean(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)27))) != (snapToGeometryStyle = NotationUtils.getBooleanValue((View)diagram, (String)"rulergrid.snaptogeometry", (boolean)snapToGeometryPref))) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)snapToGeometryPref, NotationPackage.eINSTANCE.getBooleanValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), "rulergrid.snaptogeometry");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if ((rulerUnitsPref = globalPreferenceStore.getInt(PreferencesConstantsHelper.getDiagramConstant((String)diagramType, (int)25))) - (rulerUnitsStyle = NotationUtils.getIntValue((View)diagram, (String)"rulergrid.rulerunit", (int)rulerUnitsPref)) != 0) {
                CustomStyleValueCommand customStyleValueCommand = new CustomStyleValueCommand((View)diagram, (Object)rulerUnitsPref, NotationPackage.eINSTANCE.getIntValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getIntValueStyle_IntValue(), "rulergrid.rulerunit");
                compoundCommand.append((Command)customStyleValueCommand);
            }
            if (!compoundCommand.getCommandList().isEmpty()) {
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)diagram);
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected IPreferenceStore getPreferencesStore() {
        IStructuredSelection selection = this.input.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EditPart) {
            return DiagramEditPartsUtil.getDiagramWorkspacePreferenceStore((EditPart)((EditPart)firstElement));
        }
        return null;
    }

    protected String getDiagramType() {
        Diagram diagram = this.getDiagram();
        String diagramType = "";
        if (diagram != null) {
            diagramType = diagram.getType();
        }
        return diagramType;
    }

    protected Diagram getDiagram() {
        Diagram diagram = null;
        IStructuredSelection selection = this.input.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EditPart) {
            DiagramEditPart diagramEditPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)firstElement));
            diagram = (Diagram)diagramEditPart.getAdapter(Diagram.class);
        }
        return diagram;
    }
}

