/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.utils;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class NamespaceOwnedMemberUtils {
    public static EReference getContainmentFeature(Namespace container, Namespace element) {
        ContainerFeatureSwitch classifierSwitch = new ContainerFeatureSwitch(element);
        return (EReference)classifierSwitch.doSwitch((EObject)container);
    }

    public static boolean isContainedTransitively(EObject owner, EObject owned) {
        ArrayList<EObject> owners = new ArrayList<EObject>();
        EObject it = owner;
        while (it != null) {
            owners.add(it);
            it = it.eContainer();
        }
        return owners.contains(owned);
    }

    public static boolean canContainTarget(Namespace source, Namespace target) {
        ContainerFeatureSwitch classifierSwitch = new ContainerFeatureSwitch(target);
        if (classifierSwitch.doSwitch((EObject)source) == null) {
            return false;
        }
        if (NamespaceOwnedMemberUtils.isContainedTransitively((EObject)source, (EObject)target)) {
            return false;
        }
        return !source.equals(target);
    }

    private static class ContainerFeatureSwitch
    extends UMLSwitch<EReference> {
        private final Namespace element;

        public ContainerFeatureSwitch(Namespace element) {
            this.element = element;
        }

        public EReference casePackage(Package object) {
            if (this.element instanceof PackageableElement) {
                return UMLPackage.eINSTANCE.getPackage_PackagedElement();
            }
            return (EReference)super.casePackage(object);
        }

        public EReference caseClass(Class object) {
            if (this.element instanceof Classifier) {
                return UMLPackage.eINSTANCE.getClass_NestedClassifier();
            }
            return (EReference)super.caseClass(object);
        }

        public EReference defaultCase(EObject object) {
            return null;
        }
    }
}

