/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CachedCheckboxTreeViewer
extends ContainerCheckedTreeViewer {
    private Set<Object> checkState = new HashSet<Object>();
    private static final Object[] NO_ELEMENTS = new Object[0];

    protected CachedCheckboxTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(event -> this.updateCheckState(event.getElement(), event.getChecked()));
        this.setUseHashlookup(true);
    }

    protected void updateCheckState(Object element, boolean state) {
        if (state) {
            Object[] children;
            if (this.checkState == null) {
                this.checkState = new HashSet<Object>();
            }
            if ((children = this.getFilteredChildren(element)) != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    this.updateCheckState(child, state);
                    ++n2;
                }
            } else if (!this.checkState.contains(element)) {
                this.checkState.add(element);
            }
        } else if (this.checkState != null) {
            Object[] children = this.getFilteredChildren(element);
            if (children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n3 = 0;
                while (n3 < n) {
                    Object child = objectArray[n3];
                    this.updateCheckState(child, state);
                    ++n3;
                }
            }
            this.checkState.remove(element);
        }
    }

    public void restoreLeafCheckState() {
        if (this.checkState == null) {
            return;
        }
        this.getTree().setRedraw(false);
        super.setCheckedElements(NO_ELEMENTS);
        this.setGrayedElements(NO_ELEMENTS);
        if (!this.checkState.isEmpty()) {
            this.expandAll();
        }
        super.setCheckedElements(this.checkState.toArray());
        this.getTree().setRedraw(true);
    }

    public Object[] getCheckedLeafElements() {
        if (this.checkState == null) {
            return NO_ELEMENTS;
        }
        return this.checkState.toArray(new Object[this.checkState.size()]);
    }

    public int getCheckedLeafCount() {
        if (this.checkState == null) {
            return 0;
        }
        return this.checkState.size();
    }

    public boolean isCheckedLeafElement(Object element) {
        if (this.checkState == null) {
            return false;
        }
        return this.checkState.contains(element);
    }

    public boolean setChecked(Object element, boolean state) {
        this.updateCheckState(element, state);
        return super.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        if (this.checkState == null) {
            this.checkState = new HashSet<Object>();
        } else {
            this.checkState.clear();
        }
        ITreeContentProvider contentProvider = null;
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            contentProvider = (ITreeContentProvider)this.getContentProvider();
        }
        int i = 0;
        while (i < elements.length) {
            Object[] children;
            Object[] objectArray = children = contentProvider != null ? contentProvider.getChildren(elements[i]) : null;
            if (!(this.getGrayed(elements[i]) || children != null && children.length != 0 || this.checkState.contains(elements[i]))) {
                this.checkState.add(elements[i]);
            }
            ++i;
        }
    }

    public void setAllChecked(boolean state) {
        block8: {
            Object[] visible;
            block7: {
                super.setAllChecked(state);
                if (!state) break block7;
                Object[] visible2 = this.getFilteredChildren(this.getRoot());
                if (this.checkState == null) {
                    this.checkState = new HashSet<Object>();
                }
                ITreeContentProvider contentProvider = null;
                if (this.getContentProvider() instanceof ITreeContentProvider) {
                    contentProvider = (ITreeContentProvider)this.getContentProvider();
                }
                if (contentProvider == null) {
                    Object[] objectArray = visible2;
                    int n = visible2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object visibleObject = objectArray[n2];
                        this.checkState.add(visibleObject);
                        ++n2;
                    }
                } else {
                    HashSet<Object> toCheck = new HashSet<Object>();
                    Object[] objectArray = visible2;
                    int n = visible2.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object visibleObject = objectArray[n3];
                        this.addFilteredChildren(visibleObject, contentProvider, toCheck);
                        ++n3;
                    }
                    this.checkState.addAll(toCheck);
                }
                break block8;
            }
            if (this.checkState == null) break block8;
            Object[] objectArray = visible = this.filter(this.checkState.toArray());
            int n = visible.length;
            int n4 = 0;
            while (n4 < n) {
                Object visibleObject = objectArray[n4];
                this.checkState.remove(visibleObject);
                ++n4;
            }
        }
    }

    private void addFilteredChildren(Object element, ITreeContentProvider contentProvider, Collection<Object> result) {
        if (!contentProvider.hasChildren(element)) {
            result.add(element);
        } else {
            Object[] visibleChildren;
            Object[] objectArray = visibleChildren = this.getFilteredChildren(element);
            int n = visibleChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object visibleChild = objectArray[n2];
                this.addFilteredChildren(visibleChild, contentProvider, result);
                ++n2;
            }
        }
    }

    public void remove(Object[] elementsOrTreePaths) {
        Object[] objectArray = elementsOrTreePaths;
        int n = elementsOrTreePaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object elementOrTreePath = objectArray[n2];
            this.updateCheckState(elementOrTreePath, false);
            ++n2;
        }
        super.remove(elementsOrTreePaths);
    }

    public void remove(Object elementsOrTreePaths) {
        this.updateCheckState(elementsOrTreePaths, false);
        super.remove(elementsOrTreePaths);
    }
}

