/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.buildpath.FolderSelectionDialog;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.viewsupport.ImageDisposer;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.phar.wizard.PharUIUtil;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathMessages;
import org.eclipse.php.internal.ui.preferences.includepath.PHPBuildpathOrderingWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.PHPLibrariesWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPProjectsWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPSourceContainerWorkbookPage;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class AbstractIncludepathsBlock
extends BuildpathsBlock {
    protected IWorkspaceRoot fWorkspaceRoot;
    protected ListDialogField<BPListElement> fBuildPathList;
    protected StringButtonDialogField fBuildPathDialogField;
    protected StatusInfo fPathStatus;
    protected StatusInfo fBuildPathStatus;
    protected IScriptProject fCurrScriptProject;
    protected IStatusChangeListener fContext;
    protected Control fSWTWidget;
    protected TabFolder fTabFolder;
    protected int fPageIndex;
    protected BuildPathBasePage fSourceContainerPage;
    protected PHPProjectsWorkbookPage fProjectsPage;
    protected PHPLibrariesWorkbookPage fLibrariesPage;
    protected BuildPathBasePage fCurrPage;
    protected String fUserSettingsTimeStamp;
    protected long fFileTimeStamp;
    protected IRunnableContext fRunnableContext;
    protected boolean fUseNewPage;
    protected final IWorkbenchPreferenceContainer fPageContainer;

    public AbstractIncludepathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        super(runnableContext, context, pageToShow, useNewPage, pageContainer);
        this.fPageContainer = pageContainer;
        this.fWorkspaceRoot = DLTKUIPlugin.getWorkspace().getRoot();
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        this.initContainerElements();
        this.fBuildPathStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        this.fCurrScriptProject = null;
    }

    protected void initContainerElements() {
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.BuildPathsBlock_buildpath_up_button;
        stringArray[1] = NewWizardMessages.BuildPathsBlock_buildpath_down_button;
        stringArray[3] = NewWizardMessages.BuildPathsBlock_buildpath_checkall_button;
        stringArray[4] = NewWizardMessages.BuildPathsBlock_buildpath_uncheckall_button;
        String[] buttonLabels = stringArray;
        this.fBuildPathList = new ListDialogField(null, buttonLabels, (ILabelProvider)new PHPIPListLabelProvider());
        this.fBuildPathList.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
        this.fBuildPathList.setUpButtonIndex(0);
        this.fBuildPathList.setDownButtonIndex(1);
        this.fBuildPathDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlock_buildpath_button);
        this.fBuildPathDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
    }

    protected abstract boolean supportZips();

    public void setTitle(String title) {
        this.fBuildPathList.setLabelText(title);
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.packagefolder_obj.png"));
        this.fSourceContainerPage = new PHPSourceContainerWorkbookPage(this.fBuildPathList);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = DLTKUIPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new PHPProjectsWorkbookPage(this.fBuildPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new PHPLibrariesWorkbookPage(this.supportZips(), this.fBuildPathList, this.fPageContainer);
        this.fLibrariesPage.setScriptProject(this.getScriptProject());
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_libraries);
        item.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.png"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = DLTKPluginImages.DESC_TOOL_BUILDPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        PHPBuildpathOrderingWorkbookPage ordpage = new PHPBuildpathOrderingWorkbookPage(this.fBuildPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrScriptProject != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
            this.fLibrariesPage.init(this.fCurrScriptProject);
            this.fProjectsPage.init(this.fCurrScriptProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIncludepathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    public void init(IScriptProject jproject, IBuildpathEntry[] buildpathEntries) {
        this.fCurrScriptProject = jproject;
        boolean projectExists = false;
        List<BPListElement> newBuildpath = null;
        IProject project = this.fCurrScriptProject.getProject();
        boolean bl = projectExists = project.exists() && project.getFile(".buildpath").exists();
        if (projectExists && buildpathEntries == null) {
            buildpathEntries = this.fCurrScriptProject.readRawBuildpath();
        }
        if (buildpathEntries != null) {
            newBuildpath = this.getExistingEntries(buildpathEntries);
        }
        if (newBuildpath == null) {
            newBuildpath = this.getDefaultBuildpath(jproject);
        }
        ArrayList<BPListElement> exportedEntries = new ArrayList<BPListElement>();
        int i = 0;
        while (i < newBuildpath.size()) {
            BPListElement curr = newBuildpath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fBuildPathDialogField.enableButton(project.exists());
        this.fBuildPathList.setElements(newBuildpath);
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractIncludepathsBlock.this.fSWTWidget == null || AbstractIncludepathsBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    AbstractIncludepathsBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fBuildPathDialogField.refresh();
        this.fBuildPathList.refresh();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
            this.fProjectsPage.init(this.fCurrScriptProject);
            this.fLibrariesPage.init(this.fCurrScriptProject);
        }
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fBuildPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            BPListElement elem = (BPListElement)this.fBuildPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInBuildpathFile() {
        IFile file = this.fCurrScriptProject.getProject().getFile(".buildpath");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrScriptProject.getProject().getFile(".buildpath");
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    protected List<BPListElement> getExistingEntries(IBuildpathEntry[] buildpathEntries) {
        ArrayList<BPListElement> newBuildpath = new ArrayList<BPListElement>();
        int i = 0;
        while (i < buildpathEntries.length) {
            IBuildpathEntry curr = buildpathEntries[i];
            newBuildpath.add(BPListElement.createFromExisting((IBuildpathEntry)curr, (IScriptProject)this.fCurrScriptProject));
            ++i;
        }
        return newBuildpath;
    }

    public IScriptProject getScriptProject() {
        return this.fCurrScriptProject;
    }

    public IBuildpathEntry[] getRawBuildPath() {
        List elements = this.fBuildPathList.getElements();
        int nElements = elements.size();
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            BPListElement currElement = (BPListElement)elements.get(i);
            entries[i] = currElement.getBuildpathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected List<BPListElement> getDefaultBuildpath(IScriptProject jproj) {
        ArrayList<BPListElement> list = new ArrayList<BPListElement>();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            String sourceFolderName = store.getString("org.eclipse.dltk.ui.wizards.srcFoldersSrcName");
            Object srcFolder = store.getBoolean("org.eclipse.dltk.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0 ? jproj.getProject().getFolder(sourceFolderName) : jproj.getProject();
            list.add(new BPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder, false));
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add default library");
        }
        return list;
    }

    private void buildPathChangeControlPressed(DialogField field) {
        IContainer container;
        if (field == this.fBuildPathDialogField && (container = this.chooseContainer()) != null) {
            this.fBuildPathDialogField.setText(container.getFullPath().toString());
        }
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fBuildPathList) {
            this.updatePathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fPathStatus, this.fBuildPathStatus});
    }

    public void updatePathStatus() {
        this.fPathStatus.setOK();
        List elements = this.fBuildPathList.getElements();
        BPListElement entryMissing = null;
        int nEntriesMissing = 0;
        BPListElement entryInvalid = null;
        int nEntriesInvalid = 0;
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            BPListElement currElement = (BPListElement)elements.get(i);
            entries[i] = currElement.getBuildpathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            } else if (PharUIUtil.isInvalidPharBuildEntry(currElement)) {
                ++nEntriesInvalid;
                if (entryInvalid == null) {
                    entryInvalid = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1 && entryMissing != null) {
                this.fPathStatus.setWarning(Messages.format((String)NewWizardMessages.BuildPathsBlock_warning_EntryMissing, (Object[])new Object[]{entryMissing.getPath().toString()}));
            } else {
                this.fPathStatus.setWarning(Messages.format((String)NewWizardMessages.BuildPathsBlock_warning_EntriesMissing, (Object[])new Object[]{String.valueOf(nEntriesMissing)}));
            }
        }
        if (nEntriesInvalid > 0) {
            if (nEntriesInvalid == 1 && entryInvalid != null) {
                this.fPathStatus.setError(Messages.format((String)IncludePathMessages.BuildPathsBlock_warning_EntryInvalid, (Object[])new Object[]{entryInvalid.getPath().toString()}));
            } else {
                this.fPathStatus.setError(Messages.format((String)IncludePathMessages.BuildPathsBlock_warning_EntriesInvalid, (Object[])new Object[]{String.valueOf(nEntriesInvalid)}));
            }
        }
        this.updateBuildPathStatus();
    }

    protected void updateBuildPathStatus() {
        List elements = this.fBuildPathList.getElements();
        IBuildpathEntry[] entries = new IBuildpathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            BPListElement currElement = (BPListElement)elements.get(i);
            entries[i] = currElement.getBuildpathEntry();
            --i;
        }
        IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)this.fCurrScriptProject, (IBuildpathEntry[])entries);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.BuildPathsBlock_operationdesc_project, 100);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (locationURI != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(locationURI)) {
                    locationURI = null;
                }
                desc.setLocationURI(locationURI);
                project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addScriptNature(IProject project, IProgressMonitor monitor, String nature) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!DLTKLanguageManager.hasScriptNature((IProject)project.getProject())) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            if (DLTKCore.DEBUG) {
                System.err.println("Add selection of possible natures here");
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        AbstractIncludepathsBlock.flush(this.fBuildPathList.getElements(), this.getScriptProject(), monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    public static void flush(List<BPListElement> buildpathEntries, IScriptProject javaProject, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_Script);
        monitor.beginTask("", buildpathEntries.size() * 4 + 4);
        try {
            IProject project = javaProject.getProject();
            IPath projPath = project.getFullPath();
            monitor.worked(1);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int nEntries = buildpathEntries.size();
            IBuildpathEntry[] buildpath = new IBuildpathEntry[nEntries];
            int i = 0;
            for (BPListElement entry : buildpathEntries) {
                buildpath[i] = entry.getBuildpathEntry();
                ++i;
                IResource res = entry.getResource();
                if (res instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                    CoreUtility.createFolder((IFolder)((IFolder)res), (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (entry.getEntryKind() == 3) {
                    monitor.worked(1);
                    IPath path = entry.getPath();
                    if (projPath.equals((Object)path)) {
                        monitor.worked(2);
                        continue;
                    }
                    if (projPath.isPrefixOf(path)) {
                        path = path.removeFirstSegments(projPath.segmentCount());
                    }
                    IFolder folder = project.getFolder(path);
                    IPath orginalPath = entry.getOrginalPath();
                    if (orginalPath == null) {
                        if (!folder.exists()) {
                            if (entry.getLinkTarget() == null) {
                                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            } else {
                                folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                        }
                    } else {
                        if (projPath.isPrefixOf(orginalPath)) {
                            orginalPath = orginalPath.removeFirstSegments(projPath.segmentCount());
                        }
                        IFolder orginalFolder = project.getFolder(orginalPath);
                        if (entry.getLinkTarget() == null) {
                            if (!folder.exists()) {
                                IPath parentPath = entry.getPath().removeLastSegments(1);
                                if (projPath.isPrefixOf(parentPath)) {
                                    parentPath = parentPath.removeFirstSegments(projPath.segmentCount());
                                }
                                if (parentPath.segmentCount() > 0) {
                                    IFolder parentFolder = project.getFolder(parentPath);
                                    if (!parentFolder.exists()) {
                                        CoreUtility.createFolder((IFolder)parentFolder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                } else {
                                    monitor.worked(1);
                                }
                                orginalFolder.move(entry.getPath(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        } else if (!folder.exists() || !entry.getLinkTarget().equals((Object)entry.getOrginalLinkTarget())) {
                            orginalFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else {
                    monitor.worked(3);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            javaProject.setRawBuildpath(buildpath, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (AbstractIncludepathsBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                AbstractIncludepathsBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    private IContainer chooseContainer() {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrScriptProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Object initSelection = null;
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setInitialSelection(initSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 2: 
            case 5: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private BPListElement findElement(IBuildpathEntry entry) {
        int i = 0;
        int len = this.fBuildPathList.getSize();
        while (i < len) {
            BPListElement curr = (BPListElement)this.fBuildPathList.getElement(i);
            if (curr.getEntryKind() == entry.getEntryKind() && curr.getPath().equals((Object)entry.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public void setElementToReveal(IBuildpathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            BPListElement element = this.findElement(entry);
            if (element != null) {
                BPListElementAttribute attrib;
                BPListElement elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                BuildPathBasePage page = (BuildPathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<BPListElement> selection = new ArrayList<BPListElement>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void addElement(IBuildpathEntry entry) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            Object page = this.fTabFolder.getItem(pageIndex).getData();
            if (page instanceof PHPLibrariesWorkbookPage) {
                BPListElement element = BPListElement.createFromExisting((IBuildpathEntry)entry, (IScriptProject)this.fCurrScriptProject);
                ((PHPLibrariesWorkbookPage)((Object)page)).addElement(element);
            }
        }
    }

    public class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        public void changeControlPressed(DialogField field) {
            AbstractIncludepathsBlock.this.buildPathChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            AbstractIncludepathsBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

