/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.datatools.sqltools.result.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.platform.RunningPlatform;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.datatools.sqltools.result.ui.SQLResult;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.TreeHasChildren;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class ResultView
extends WorkbenchView {
    public ResultView() {
        super("SQL Results");
    }

    public List<SQLResult> getResults() {
        this.open();
        Tree tree = this.getViewTree();
        List items = tree.getItems();
        ArrayList<SQLResult> results = new ArrayList<SQLResult>();
        for (TreeItem item : items) {
            results.add(new SQLResult(item.getCell(0), item.getCell(1), item.getCell(2), item.getCell(3)));
        }
        return results;
    }

    public void removeAllResults() {
        this.open();
        Tree tree = this.getViewTree();
        new WaitUntil((WaitCondition)new TreeHasChildren(tree), TimePeriod.DEFAULT, false);
        String tooltip = "Remove All Visible Results (Shift+Delete)";
        if (RunningPlatform.isOSX()) {
            tooltip = "Remove All Visible Results (\u21e7\u2326)";
        }
        DefaultToolItem item = new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), tooltip);
        item.click();
        new WaitWhile((WaitCondition)new TreeHasChildren(tree), TimePeriod.LONG);
    }

    private Tree getViewTree() {
        return new DefaultTree((ReferencedComposite)this.cTabItem);
    }
}

