/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.logging.LoggingUtils;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.handler.TableHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.condition.TableHasRows;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.hamcrest.Matcher;

public abstract class AbstractTable
extends AbstractControl<Table>
implements org.eclipse.reddeer.swt.api.Table {
    private static final Logger log = Logger.getLogger(AbstractTable.class);

    protected AbstractTable(Table swtWidget) {
        super(swtWidget);
    }

    protected AbstractTable(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(Table.class, refComposite, index, matchers);
    }

    @Override
    public boolean containsItem(String item) {
        for (org.eclipse.reddeer.swt.api.TableItem it : this.getItems()) {
            if (!it.getText().equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(String item, int cellIndex) {
        for (org.eclipse.reddeer.swt.api.TableItem it : this.getItems()) {
            if (!it.getText(cellIndex).equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.TableItem> getItems() {
        this.waitUntilTableHasRows();
        TableItem[] items = TableHandler.getInstance().getSWTItems((Table)this.swtWidget);
        ArrayList<org.eclipse.reddeer.swt.api.TableItem> tableItems = new ArrayList<org.eclipse.reddeer.swt.api.TableItem>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            tableItems.add(new DefaultTableItem(i));
            ++n2;
        }
        return tableItems;
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.TableItem> getItems(Matcher<org.eclipse.reddeer.swt.api.TableItem> ... matchers) {
        ArrayList<org.eclipse.reddeer.swt.api.TableItem> matchedItems = new ArrayList<org.eclipse.reddeer.swt.api.TableItem>();
        for (org.eclipse.reddeer.swt.api.TableItem item : this.getItems()) {
            int index = 0;
            while (index < matchers.length && matchers[index].matches((Object)item)) {
                ++index;
            }
            if (index != matchers.length) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public org.eclipse.reddeer.swt.api.TableItem getItem(int index) {
        this.waitUntilTableHasRows();
        TableItem tItem = TableHandler.getInstance().getSWTItem((Table)this.swtWidget, index);
        return new DefaultTableItem(tItem);
    }

    @Override
    public org.eclipse.reddeer.swt.api.TableItem getItem(String itemText) {
        this.waitUntilTableHasRows();
        int row = TableHandler.getInstance().indexOf((Table)this.swtWidget, itemText, 0);
        TableItem tItem = TableHandler.getInstance().getSWTItem((Table)this.swtWidget, row);
        return new DefaultTableItem(tItem);
    }

    @Override
    public org.eclipse.reddeer.swt.api.TableItem getItem(String itemText, int column) {
        this.waitUntilTableHasRows();
        int row = TableHandler.getInstance().indexOf((Table)this.swtWidget, itemText, column);
        TableItem tItem = TableHandler.getInstance().getSWTItem((Table)this.swtWidget, row);
        return new DefaultTableItem(tItem);
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.TableItem> getItems(String ... itemTexts) {
        this.waitUntilTableHasRows();
        ArrayList<org.eclipse.reddeer.swt.api.TableItem> matchedItems = new ArrayList<org.eclipse.reddeer.swt.api.TableItem>();
        for (org.eclipse.reddeer.swt.api.TableItem item : this.getItems()) {
            int index = 0;
            while (index < itemTexts.length && item.getText(index).equals(itemTexts[index])) {
                ++index;
            }
            if (index != itemTexts.length) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public int rowCount() {
        return TableHandler.getInstance().rowCount((Table)this.swtWidget);
    }

    @Override
    public void select(int ... indexes) {
        log.info("Select table rows with indexes (" + LoggingUtils.format((int[])indexes) + ")");
        this.waitUntilTableHasRows();
        if (indexes.length == 1) {
            TableHandler.getInstance().select((Table)this.swtWidget, indexes[0]);
        } else {
            TableHandler.getInstance().select((Table)this.swtWidget, indexes);
        }
    }

    @Override
    public void select(String ... items) {
        log.info("Select table rows (" + LoggingUtils.format((Object[])items) + ")");
        this.waitUntilTableHasRows();
        int[] indicies = new int[items.length];
        int i = 0;
        while (i < items.length) {
            indicies[i] = TableHandler.getInstance().indexOf((Table)this.swtWidget, items[i], 0);
            ++i;
        }
        this.select(indicies);
    }

    @Override
    public void selectAll() {
        log.info("Select all table rows");
        this.waitUntilTableHasRows();
        TableHandler.getInstance().selectAll((Table)this.swtWidget);
    }

    @Override
    public void deselectAll() {
        log.info("Deselect all table rows");
        this.waitUntilTableHasRows();
        TableHandler.getInstance().deselectAll((Table)this.swtWidget);
    }

    private void waitUntilTableHasRows() {
        new WaitUntil((WaitCondition)new TableHasRows(this), TimePeriod.SHORT, false);
    }

    @Override
    public int indexOf(org.eclipse.reddeer.swt.api.TableItem tableItem) {
        return TableHandler.getInstance().indexOf((Table)this.swtWidget, (TableItem)tableItem.getSWTWidget());
    }

    public Control getControl() {
        return (Control)this.swtWidget;
    }

    @Override
    public List<String> getHeaders() {
        return TableHandler.getInstance().getHeaders((Table)this.swtWidget);
    }

    @Override
    public int getHeaderIndex(String header) {
        List<String> headers = this.getHeaders();
        int i = 0;
        while (i < headers.size()) {
            if (headers.get(i).equals(header)) {
                return i;
            }
            ++i;
        }
        log.debug("Available headers: " + this.getHeaders());
        throw new SWTLayerException("There is no header with label " + header + " in table.");
    }

    @Override
    public String getHeader(int index) {
        List<String> headers = this.getHeaders();
        if (index < 0) {
            log.debug("Available headers: " + headers);
            throw new SWTLayerException("Cannot get header with negative index.");
        }
        if (headers.size() <= index) {
            log.debug("Available headers: " + headers);
            throw new SWTLayerException("Cannot get header with index " + index + " because table contains only " + headers.size() + " items(s).");
        }
        return headers.get(index);
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.TableItem> getSelectedItems() {
        LinkedList<org.eclipse.reddeer.swt.api.TableItem> result = new LinkedList<org.eclipse.reddeer.swt.api.TableItem>();
        for (org.eclipse.reddeer.swt.api.TableItem tableItem : this.getItems()) {
            if (!tableItem.isSelected()) continue;
            result.addLast(tableItem);
        }
        return result;
    }

    @Override
    @Deprecated
    public List<org.eclipse.reddeer.swt.api.TableItem> getSelectetItems() {
        return this.getSelectedItems();
    }
}

