/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.userprofile.UserProfile;

public class RedDeerJavaArgumentsTab
extends JavaArgumentsTab {
    private static final Logger log = Logger.getLogger(JavaArgumentsTab.class);
    public static final String VM_ARGS_ATTR_NAME = "org.eclipse.jdt.launching.VM_ARGUMENTS";
    public static final String PROGRAM_ARGS_ATTR_NAME = "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS";
    private static final String REDDEER_VM_ARGS_TO_ADD = "org.eclipse.reddeer.VM_ARGUMENTS_TO_ADD";
    private static final String REDDEER_PROGRAM_ARGS_TO_ADD = "org.eclipse.reddeer.PROGRAM_ARGUMENTS_TO_ADD";

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String userProfileProgramArgs;
        super.setDefaults(config);
        String userProfileVMargs = UserProfile.getInstance().getProperty("vmArgs");
        if (userProfileVMargs != null && userProfileVMargs.length() > 0) {
            config.setAttribute(REDDEER_VM_ARGS_TO_ADD, userProfileVMargs);
        }
        if ((userProfileProgramArgs = UserProfile.getInstance().getProperty("programArgs")) != null && userProfileProgramArgs.length() > 0) {
            config.setAttribute(REDDEER_PROGRAM_ARGS_TO_ADD, userProfileProgramArgs);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String reddeerVMArgsToAdd = configuration.getAttribute(REDDEER_VM_ARGS_TO_ADD, "");
            if (reddeerVMArgsToAdd.length() > 0) {
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute(REDDEER_VM_ARGS_TO_ADD, "");
                String currentVMArgs = configuration.getAttribute(VM_ARGS_ATTR_NAME, "");
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute(VM_ARGS_ATTR_NAME, String.valueOf(currentVMArgs) + (currentVMArgs.length() > 0 ? " " : "") + reddeerVMArgsToAdd);
            }
        }
        catch (CoreException ce) {
            log.error("Unable to set launch configuration property : org.eclipse.reddeer.VM_ARGUMENTS_TO_ADD", (Throwable)ce);
        }
        try {
            String reddeerProgramArgsToAdd = configuration.getAttribute(REDDEER_PROGRAM_ARGS_TO_ADD, "");
            if (reddeerProgramArgsToAdd.length() > 0) {
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute(REDDEER_PROGRAM_ARGS_TO_ADD, "");
                String currentProgramArgs = configuration.getAttribute(PROGRAM_ARGS_ATTR_NAME, "");
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute(PROGRAM_ARGS_ATTR_NAME, String.valueOf(currentProgramArgs) + (currentProgramArgs.length() > 0 ? " " : "") + reddeerProgramArgsToAdd);
            }
        }
        catch (CoreException ce) {
            log.error("Unable to set launch configuration property : org.eclipse.reddeer.PROGRAM_ARGUMENTS_TO_ADD", (Throwable)ce);
        }
        super.initializeFrom(configuration);
    }
}

