/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.interfaces.IOptionListener;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public abstract class CompositeSearchable
implements ISearchable {
    private ISearchable[] searchables;

    public void setSearchables(ISearchable ... searchables) {
        Assert.isNotNull((Object)searchables);
        this.searchables = searchables;
    }

    @Override
    public void createCommonPart(TreeViewerSearchDialog dialog, Composite parent) {
        Assert.isNotNull((Object)this.searchables, (String)"setSearchables must be called before!");
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.createCommonPart(dialog, parent);
            ++n2;
        }
    }

    @Override
    public void createAdvancedPart(TreeViewerSearchDialog dialog, Composite parent) {
        Section section = new Section(parent, 18);
        section.setText(Messages.TreeViewerSearchDialog_AdvancedOptions);
        section.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        GridData layoutData = new GridData(768);
        section.setLayoutData((Object)layoutData);
        final Composite advancedPart = new Composite((Composite)section, 0);
        advancedPart.setLayout((Layout)new GridLayout());
        advancedPart.setLayoutData((Object)new GridData(768));
        advancedPart.setBackground(section.getBackground());
        section.setClient((Control)advancedPart);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                boolean state = e.getState();
                int client_height = advancedPart.getSize().y;
                Shell shell = advancedPart.getShell();
                Point p = shell.getSize();
                p.y = state ? p.y + client_height : p.y - client_height;
                shell.setSize(p.x, p.y);
            }
        });
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.createAdvancedPart(dialog, advancedPart);
            ++n2;
        }
    }

    @Override
    public ISearchMatcher getMatcher() {
        ISearchMatcher[] matchers = new ISearchMatcher[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            matchers[i] = this.searchables[i].getMatcher();
            ++i;
        }
        return new CompositeMatcher(matchers);
    }

    @Override
    public boolean isInputValid() {
        boolean valid = true;
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            valid &= searchable.isInputValid();
            ++n2;
        }
        return valid;
    }

    @Override
    public void addOptionListener(IOptionListener listener) {
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.addOptionListener(listener);
            ++n2;
        }
    }

    @Override
    public void restoreValues(IDialogSettings settings) {
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.restoreValues(settings);
            ++n2;
        }
    }

    @Override
    public void persistValues(IDialogSettings settings) {
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.persistValues(settings);
            ++n2;
        }
    }

    @Override
    public void removeOptionListener(IOptionListener listener) {
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            searchable.removeOptionListener(listener);
            ++n2;
        }
    }

    @Override
    public Point getPreferredSize() {
        Point size = null;
        ISearchable[] iSearchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchable searchable = iSearchableArray[n2];
            Point prefSize = searchable.getPreferredSize();
            if (prefSize != null) {
                if (size == null) {
                    size = new Point(0, 0);
                }
                size.x = Math.max(size.x, prefSize.x);
                size.y += prefSize.y;
            }
            ++n2;
        }
        return size;
    }

    static class CompositeMatcher
    implements ISearchMatcher {
        private ISearchMatcher[] matchers;

        public CompositeMatcher(ISearchMatcher[] matchers) {
            Assert.isNotNull((Object)matchers);
            this.matchers = matchers;
        }

        @Override
        public boolean match(Object element) {
            ISearchMatcher[] iSearchMatcherArray = this.matchers;
            int n = this.matchers.length;
            int n2 = 0;
            while (n2 < n) {
                ISearchMatcher matcher = iSearchMatcherArray[n2];
                if (!matcher.match(element)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

