/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.analysis.counters.core.aspects.ITmfCounterAspect;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.MultiAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CounterStateProvider
extends AbstractTmfStateProvider {
    private static final Logger LOGGER = TraceCompassLog.getLogger(CounterStateProvider.class);
    private final Set<ITmfEventAspect<?>> fCounterAspects;
    private final Map<Class<? extends ITmfEventAspect<?>>, ITmfEventAspect<?>> fGroupingAspectImpls;

    public static CounterStateProvider create(ITmfTrace trace) {
        HashMap aspectImpls = new HashMap();
        Iterable counterAspects = TmfTraceUtils.getEventAspects((ITmfTrace)trace, ITmfCounterAspect.class);
        for (ITmfEventAspect counter : counterAspects) {
            if (!(counter instanceof CounterAspect)) continue;
            CounterAspect counterAspect = (CounterAspect)counter;
            Class<? extends ITmfEventAspect<?>>[] classArray = counterAspect.getGroups();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfEventAspect goldenAspect;
                Class<ITmfEventAspect<?>> parentAspectClass = classArray[n2];
                if (parentAspectClass != null && !aspectImpls.containsKey(parentAspectClass) && (goldenAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, parentAspectClass), parentAspectClass.getClass())) != null) {
                    aspectImpls.put(parentAspectClass, goldenAspect);
                }
                ++n2;
            }
        }
        return new CounterStateProvider(trace, counterAspects, aspectImpls);
    }

    private CounterStateProvider(ITmfTrace trace, Iterable<ITmfEventAspect<?>> counterAspects, Map<Class<? extends ITmfEventAspect<?>>, ITmfEventAspect<?>> aspectImpls) {
        super(trace, "org.eclipse.tracecompass.analysis.counters.core.counteranalysis");
        this.fCounterAspects = ImmutableSet.copyOf(counterAspects);
        this.fGroupingAspectImpls = ImmutableMap.copyOf(aspectImpls);
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new CounterStateProvider(this.getTrace(), this.fCounterAspects, this.fGroupingAspectImpls);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            return;
        }
        for (ITmfEventAspect<?> aspect : this.fCounterAspects) {
            int rootQuark;
            if (!(aspect instanceof CounterAspect)) continue;
            CounterAspect counterAspect = (CounterAspect)aspect;
            if (counterAspect.getGroups().length > 0) {
                rootQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Grouped"});
                this.handleGroupedCounterAspect(event, ss, counterAspect, rootQuark);
                continue;
            }
            rootQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Ungrouped"});
            CounterStateProvider.handleCounterAspect(event, ss, counterAspect, rootQuark);
        }
    }

    protected void handleGroupedCounterAspect(ITmfEvent event, ITmfStateSystemBuilder ss, CounterAspect aspect, int rootQuark) {
        int quark = rootQuark;
        Class<? extends ITmfEventAspect<?>>[] classArray = aspect.getGroups();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<ITmfEventAspect<?>> groupClass = classArray[n2];
            ITmfEventAspect<?> parentAspect = this.fGroupingAspectImpls.get(groupClass);
            if (parentAspect != null) {
                Object parentAspectContent = parentAspect.resolve(event);
                if (parentAspectContent != null) {
                    quark = ss.getQuarkRelativeAndAdd(quark, new String[]{parentAspect.getName()});
                    quark = ss.getQuarkRelativeAndAdd(quark, new String[]{String.valueOf(parentAspectContent)});
                } else {
                    return;
                }
            }
            ++n2;
        }
        CounterStateProvider.handleCounterAspect(event, ss, aspect, quark);
    }

    private static void handleCounterAspect(ITmfEvent event, ITmfStateSystemBuilder ss, CounterAspect aspect, int rootQuark) {
        int quark = ss.getQuarkRelativeAndAdd(rootQuark, new String[]{aspect.getName()});
        Long eventContent = aspect.resolve(event);
        if (eventContent != null) {
            if (!aspect.isCumulative()) {
                try {
                    StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ss, (long)event.getTimestamp().toNanos(), (int)quark, (long)eventContent);
                }
                catch (AttributeNotFoundException | StateValueTypeException e) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"HandleCounterAspect:Exception", (Object[])new Object[]{e});
                }
            } else {
                ss.modifyAttribute(event.getTimestamp().toNanos(), (Object)eventContent, quark);
            }
        }
    }
}

