/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo.UstDebugInfoSymbolProviderPreferencePage;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.FunctionLocation;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoFunctionAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.symbols.DefaultSymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;

public class UstDebugInfoSymbolProvider
extends DefaultSymbolProvider
implements org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider {
    private final List<ISymbolProvider> fOtherProviders = new ArrayList<ISymbolProvider>();

    public UstDebugInfoSymbolProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace);
    }

    void setConfiguredPathPrefix(LttngUstTrace.SymbolProviderConfig newConfig) {
        this.getTrace().setSymbolProviderConfig(newConfig);
    }

    public void loadConfiguration(@Nullable IProgressMonitor monitor) {
        super.loadConfiguration(monitor);
        for (ISymbolProvider provider : SymbolProviderManager.getInstance().getSymbolProviders((ITmfTrace)this.getTrace())) {
            if (provider instanceof DefaultSymbolProvider) continue;
            this.fOtherProviders.add(provider);
        }
    }

    public @NonNull LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public @Nullable TmfResolvedSymbol getSymbol(int pid, long timestamp, long address) {
        BinaryCallsite bc = UstDebugInfoBinaryAspect.getBinaryCallsite((LttngUstTrace)this.getTrace(), (int)pid, (long)timestamp, (long)address);
        if (bc == null) {
            return null;
        }
        FunctionLocation loc = UstDebugInfoFunctionAspect.getFunctionFromBinaryLocation((BinaryCallsite)bc);
        if (loc != null) {
            return new TmfResolvedSymbol(bc.getOffset(), loc.getFunctionName());
        }
        for (ISymbolProvider provider : this.fOtherProviders) {
            TmfResolvedSymbol symbol = provider.getSymbol(pid, timestamp, bc.getOffset());
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public @NonNull ISymbolProviderPreferencePage createPreferencePage() {
        return new UstDebugInfoSymbolProviderPreferencePage(this);
    }
}

