/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DataDrivenXYProviderFactory
implements IDataDrivenRuntimeObject {
    private final List<DataDrivenOutputEntry> fEntries;
    private final Set<String> fAnalysisIds;

    public DataDrivenXYProviderFactory(List<DataDrivenOutputEntry> entries, Set<String> analysisIds) {
        this.fEntries = entries;
        this.fAnalysisIds = analysisIds;
    }

    public @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> create(ITmfTrace trace) {
        HashSet<@NonNull ITmfAnalysisModuleWithStateSystems> stateSystemModules = new HashSet<ITmfAnalysisModuleWithStateSystems>();
        ArrayList<ITmfStateSystem> sss = new ArrayList<ITmfStateSystem>();
        if (this.fAnalysisIds.isEmpty()) {
            Iterables.addAll(stateSystemModules, (Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class));
        } else {
            for (String moduleId : this.fAnalysisIds) {
                IAnalysisModule module = trace.getAnalysisModule(moduleId);
                if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
                stateSystemModules.add((ITmfAnalysisModuleWithStateSystems)module);
            }
        }
        for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
            if (!module.schedule().isOK() || !module.waitForInitialization()) continue;
            module.getStateSystems().forEach(sss::add);
        }
        return sss.isEmpty() ? null : new DataDrivenXYDataProvider(trace, sss, this.fEntries, null);
    }
}

