/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class TimeEvent
implements ITimeEvent {
    protected ITimeGraphEntry fEntry;
    protected long fTime;
    protected long fDuration;
    private final int fValue;
    private int fActiveProperties = 0;
    private static final int NOVALUE = Integer.MIN_VALUE;

    public TimeEvent(ITimeGraphEntry entry, long time, long duration) {
        this(entry, time, duration, Integer.MIN_VALUE);
    }

    public TimeEvent(ITimeGraphEntry entry, long time, long duration, int value) {
        this.fEntry = entry;
        this.fTime = time;
        this.fDuration = duration;
        this.fValue = value;
    }

    public TimeEvent(ITimeGraphEntry entry, long time, long duration, int value, int activeProperties) {
        this.fEntry = entry;
        this.fTime = time;
        this.fDuration = duration;
        this.fValue = value;
        this.fActiveProperties = activeProperties;
    }

    public int getValue() {
        return this.fValue;
    }

    public boolean hasValue() {
        return this.fValue != Integer.MIN_VALUE;
    }

    @Override
    public ITimeGraphEntry getEntry() {
        return this.fEntry;
    }

    @Override
    public long getTime() {
        return this.fTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    @Override
    public ITimeEvent splitBefore(long splitTime) {
        return splitTime > this.fTime ? new TimeEvent(this.fEntry, this.fTime, Math.min(this.fDuration, splitTime - this.fTime), this.fValue) : null;
    }

    @Override
    public ITimeEvent splitAfter(long splitTime) {
        return splitTime < this.fTime + this.fDuration ? new TimeEvent(this.fEntry, Math.max(this.fTime, splitTime), this.fDuration - Math.max(0L, splitTime - this.fTime), this.fValue) : null;
    }

    public int hashCode() {
        return Objects.hash(this.fEntry, this.fTime, this.fDuration, this.fValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeEvent other = (TimeEvent)obj;
        return Objects.equals(this.fEntry, other.fEntry) && Objects.equals(this.fTime, other.fTime) && Objects.equals(this.fDuration, other.fDuration) && Objects.equals(this.fValue, other.fValue);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " start=" + this.fTime + " end=" + (this.fTime + this.fDuration) + " duration=" + this.fDuration + (this.hasValue() ? " value=" + this.fValue : "");
    }

    public int getActiveProperties() {
        return this.fActiveProperties;
    }

    public void setActiveProperties(int activeProperties) {
        this.fActiveProperties = activeProperties;
    }

    @Override
    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return HashMultimap.create();
    }
}

