/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IssueCodes;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IPatternMatch} implementation inferer.
 * 
 * @author Mark Czotter
 * @noreference
 */
@SuppressWarnings("all")
public class PatternMatchClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private TypeReferences typeReference;
  
  @Inject
  private IErrorFeedback feedback;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  @Extension
  private JvmAnnotationReferenceBuilder annBuilder;
  
  @Inject
  @Extension
  private IJvmModelAssociator associator;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  public Boolean inferMatchClassElements(final JvmDeclaredType it, final Pattern pattern, final JvmType querySpecificationClass, final JvmTypeReferenceBuilder builder, final JvmAnnotationReferenceBuilder annBuilder) {
    boolean _xtrycatchfinallyexpression = false;
    try {
      boolean _xblockexpression = false;
      {
        this.builder = builder;
        this.annBuilder = annBuilder;
        this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocMatchClass(pattern).toString());
        it.setAbstract(true);
        this.inferMatchClassFields(it, pattern);
        this.inferMatchClassConstructors(it, pattern);
        this.inferMatchClassGetters(it, pattern);
        this.inferMatchClassSetters(it, pattern);
        this.inferMatchClassMethods(it, pattern, this.builder.typeRef(querySpecificationClass));
        _xblockexpression = this.inferMatchInnerClasses(it, pattern);
      }
      _xtrycatchfinallyexpression = _xblockexpression;
    } catch (final Throwable _t) {
      if (_t instanceof IllegalStateException) {
        final IllegalStateException ex = (IllegalStateException)_t;
        this.feedback.reportError(pattern, ex.getMessage(), IssueCodes.OTHER_ISSUE, Severity.ERROR, 
          IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return Boolean.valueOf(_xtrycatchfinallyexpression);
  }
  
  /**
   * Infers fields for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassFields(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<Variable> _parameters = pattern.getParameters();
      for (final Variable variable : _parameters) {
        EList<JvmMember> _members = matchClass.getMembers();
        JvmField _field = this._eMFJvmTypesBuilder.toField(variable, this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable));
        this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      }
      EList<JvmMember> _members_1 = matchClass.getMembers();
      final Procedure1<JvmField> _function = (JvmField it) -> {
        it.setStatic(true);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("makeImmutableList(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable variable : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                _builder.append("\"");
                String _name = variable.getName();
                _builder.append(_name);
                _builder.append("\"");
              }
            }
            _builder.append(")");
          }
        };
        this._eMFJvmTypesBuilder.setInitializer(it, _client);
      };
      JvmField _field_1 = this._eMFJvmTypesBuilder.toField(pattern, "parameterNames", this.builder.typeRef(List.class, this.builder.typeRef(String.class)), _function);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers constructors for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassConstructors(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    final Procedure1<JvmConstructor> _function = (JvmConstructor it) -> {
      it.setVisibility(JvmVisibility.PRIVATE);
      EList<Variable> _parameters = pattern.getParameters();
      for (final Variable variable : _parameters) {
        {
          final JvmTypeReference javaType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
          EList<JvmFormalParameter> _parameters_1 = it.getParameters();
          JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(variable, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable), javaType);
          this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
        }
      }
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            EList<Variable> _parameters = pattern.getParameters();
            for(final Variable variable : _parameters) {
              _builder.append("this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName);
              _builder.append(" = ");
              String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
              _builder.append(_parameterName);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      };
      this._eMFJvmTypesBuilder.setBody(it, _client);
    };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
    return this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
  }
  
  /**
   * Infers getters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassGetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
      EList<JvmAnnotationReference> _annotations = it.getAnnotations();
      JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
      this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
      EList<JvmFormalParameter> _parameters = it.getParameters();
      JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", this.builder.typeRef(String.class));
      this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          {
            EList<Variable> _parameters = pattern.getParameters();
            for(final Variable variable : _parameters) {
              _builder.append("if (\"");
              String _name = variable.getName();
              _builder.append(_name);
              _builder.append("\".equals(parameterName)) return this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("return null;");
          _builder.newLine();
        }
      };
      this._eMFJvmTypesBuilder.setBody(it, _client);
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "get", this.builder.typeRef(Object.class), _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      {
        final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName);
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          };
          this._eMFJvmTypesBuilder.setBody(it, _client);
        };
        final JvmOperation getter = this._eMFJvmTypesBuilder.toMethod(variable, this._eMFPatternLanguageJvmModelInferrerUtil.getterMethodName(variable), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable), _function_1);
        EList<JvmMember> _members_1 = matchClass.getMembers();
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, getter);
        this.associator.associatePrimary(variable, getter);
      }
    }
  }
  
  /**
   * Infers setters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassSetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
      it.setReturnType(this.builder.typeRef(Boolean.TYPE));
      EList<JvmAnnotationReference> _annotations = it.getAnnotations();
      JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
      this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
      EList<JvmFormalParameter> _parameters = it.getParameters();
      JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", this.builder.typeRef(String.class));
      this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
      EList<JvmFormalParameter> _parameters_1 = it.getParameters();
      JvmFormalParameter _parameter_1 = this._eMFJvmTypesBuilder.toParameter(pattern, "newValue", this.builder.typeRef(Object.class));
      this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
          _builder.newLine();
          {
            EList<Variable> _parameters = pattern.getParameters();
            for(final Variable variable : _parameters) {
              final JvmTypeReference type = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
              _builder.newLineIfNotEmpty();
              _builder.append("if (\"");
              String _name = variable.getName();
              _builder.append(_name);
              _builder.append("\".equals(parameterName) ");
              {
                boolean _is = PatternMatchClassInferrer.this.typeReference.is(type, Object.class);
                if (_is) {
                  _builder.append("&& newValue instanceof ");
                  _builder.append(type);
                }
              }
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("    ");
              _builder.append("this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName, "    ");
              _builder.append(" = (");
              _builder.append(type, "    ");
              _builder.append(") newValue;");
              _builder.newLineIfNotEmpty();
              _builder.append("    ");
              _builder.append("return true;");
              _builder.newLine();
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("return false;");
          _builder.newLine();
        }
      };
      this._eMFJvmTypesBuilder.setBody(it, _client);
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "set", this.builder.typeRef(boolean.class), _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      EList<JvmMember> _members_1 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
        it.setReturnType(this.builder.typeRef(Void.TYPE));
        EList<JvmFormalParameter> _parameters_1 = it.getParameters();
        JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(variable, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable));
        this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
            _builder.newLine();
            _builder.append("this.");
            String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
            _builder.append(_fieldName);
            _builder.append(" = ");
            String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
            _builder.append(_parameterName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, this._eMFPatternLanguageJvmModelInferrerUtil.setterMethodName(variable), null, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
  }
  
  /**
   * Infers methods for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassMethods(final JvmDeclaredType matchClass, final Pattern pattern, final JvmTypeReference querySpecificationClassRef) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return \"");
            QualifiedName _fullyQualifiedName = PatternMatchClassInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(pattern);
            _builder.append(_fullyQualifiedName);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "patternName", this.builder.typeRef(String.class), _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            _builder.append(matchClass);
            _builder.append(".parameterNames;");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "parameterNames", this.builder.typeRef(List.class, this.builder.typeRef(String.class)), _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      EList<JvmMember> _members_2 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_2 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new Object[]{");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable variable : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName);
              }
            }
            _builder.append("};");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "toArray", this._eMFJvmTypesBuilder.addArrayTypeDimension(this.builder.typeRef(Object.class)), _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      EList<JvmMember> _members_3 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_3 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return isMutable() ? newMatch(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable variable : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName);
              }
            }
            _builder.append(") : this;");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "toImmutable", this.builder.typeRef(matchClass), _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      EList<JvmMember> _members_4 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_4 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              boolean _isEmpty = pattern.getParameters().isEmpty();
              if (_isEmpty) {
                _builder.append("return \"[]\";");
                _builder.newLine();
              } else {
                _builder.append(StringBuilder.class);
                _builder.append(" result = new ");
                _builder.append(StringBuilder.class);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable variable : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(" + \", \");\n", "");
                    }
                    _builder.append("result.append(\"\\\"");
                    String _name = variable.getName();
                    _builder.append(_name);
                    _builder.append("\\\"=\" + prettyPrintValue(");
                    String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                    _builder.append(_fieldName);
                    _builder.append(")");
                  }
                  if (_hasElements) {
                    _builder.append(");\n");
                  }
                }
                _builder.newLineIfNotEmpty();
                _builder.append("return result.toString();");
                _builder.newLine();
              }
            }
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(pattern, "prettyPrint", this.builder.typeRef(String.class), _function_4);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
      EList<JvmMember> _members_5 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_5 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            _builder.append(Objects.class);
            _builder.append(".hash(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable variable : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName);
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(pattern, "hashCode", this.builder.typeRef(int.class), _function_5);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
      EList<JvmMember> _members_6 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_6 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(pattern, "obj", this.builder.typeRef(Object.class));
        this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("if (this == obj)");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("if (obj == null) {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("if ((obj instanceof ");
            _builder.append(matchClass);
            _builder.append(")) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _isEmpty = pattern.getParameters().isEmpty();
              boolean _not = (!_isEmpty);
              if (_not) {
                _builder.append("    ");
                _builder.append(matchClass, "    ");
                _builder.append(" other = (");
                _builder.append(matchClass, "    ");
                _builder.append(") obj;");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable variable : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                      _builder.append("return ", "    ");
                    } else {
                      _builder.appendImmediate(" && ", "    ");
                    }
                    _builder.append(Objects.class, "    ");
                    _builder.append(".equals(");
                    String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                    _builder.append(_fieldName, "    ");
                    _builder.append(", other.");
                    String _fieldName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                    _builder.append(_fieldName_1, "    ");
                    _builder.append(")");
                  }
                  if (_hasElements) {
                    _builder.append(";", "    ");
                  }
                }
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("    ");
                _builder.append("return true;");
                _builder.newLine();
              }
            }
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("// this should be infrequent");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("if (!(obj instanceof ");
            _builder.append(IPatternMatch.class, "    ");
            _builder.append(")) {");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append(IPatternMatch.class, "    ");
            _builder.append(" otherSig  = (");
            _builder.append(IPatternMatch.class, "    ");
            _builder.append(") obj;");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return ");
            _builder.append(Objects.class, "    ");
            _builder.append(".equals(specification(), otherSig.specification()) && ");
            _builder.append(Arrays.class, "    ");
            _builder.append(".deepEquals(toArray(), otherSig.toArray());");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(pattern, "equals", this.builder.typeRef(boolean.class), _function_6);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
      EList<JvmMember> _members_7 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_7 = (JvmOperation it) -> {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            String _simpleName = querySpecificationClassRef.getType().getSimpleName();
            _builder.append(_simpleName);
            _builder.append(".instance();");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(pattern, "specification", querySpecificationClassRef, _function_7);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
      EList<JvmMember> _members_8 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_8 = (JvmOperation it) -> {
        it.setStatic(true);
        this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocNewEmptyMatchMethod(pattern).toString());
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new Mutable(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable p : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                _builder.append("null");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_8 = this._eMFJvmTypesBuilder.toMethod(pattern, "newEmptyMatch", this.builder.typeRef(matchClass), _function_8);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_8, _method_8);
      EList<JvmMember> _members_9 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_9 = (JvmOperation it) -> {
        it.setStatic(true);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        final Function1<Variable, JvmFormalParameter> _function_10 = (Variable it_1) -> {
          return this._eMFJvmTypesBuilder.toParameter(it_1, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(it_1), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(it_1));
        };
        List<JvmFormalParameter> _map = ListExtensions.<Variable, JvmFormalParameter>map(pattern.getParameters(), _function_10);
        this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _map);
        this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocNewMutableMatchMethod(pattern).toString());
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new Mutable(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable p : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                _builder.append(_parameterName);
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_9 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMutableMatch", this.builder.typeRef(matchClass), _function_9);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_9, _method_9);
      EList<JvmMember> _members_10 = matchClass.getMembers();
      final Procedure1<JvmOperation> _function_10 = (JvmOperation it) -> {
        it.setStatic(true);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        final Function1<Variable, JvmFormalParameter> _function_11 = (Variable it_1) -> {
          return this._eMFJvmTypesBuilder.toParameter(it_1, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(it_1), this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(it_1));
        };
        List<JvmFormalParameter> _map = ListExtensions.<Variable, JvmFormalParameter>map(pattern.getParameters(), _function_11);
        this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _map);
        this._eMFJvmTypesBuilder.setDocumentation(it, this._javadocInferrer.javadocNewMatchMethod(pattern).toString());
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return new Immutable(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable p : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(p);
                _builder.append(_parameterName);
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method_10 = this._eMFJvmTypesBuilder.toMethod(pattern, "newMatch", this.builder.typeRef(matchClass), _function_10);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_10, _method_10);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers inner classes for Match class based on the input 'pattern'.
   */
  public boolean inferMatchInnerClasses(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      JvmGenericType _makeMatchInnerClass = this.makeMatchInnerClass(matchClass, pattern, this._eMFPatternLanguageJvmModelInferrerUtil.matchMutableInnerClassName(pattern), true);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _makeMatchInnerClass);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      JvmGenericType _makeMatchInnerClass_1 = this.makeMatchInnerClass(matchClass, pattern, this._eMFPatternLanguageJvmModelInferrerUtil.matchImmutableInnerClassName(pattern), false);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _makeMatchInnerClass_1);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers a single inner class for Match class
   */
  public JvmGenericType makeMatchInnerClass(final JvmDeclaredType matchClass, final Pattern pattern, final String innerClassName, final boolean isMutable) {
    final Procedure1<JvmGenericType> _function = (JvmGenericType it) -> {
      it.setVisibility(JvmVisibility.PRIVATE);
      it.setStatic(true);
      it.setFinal(true);
      EList<JvmTypeReference> _superTypes = it.getSuperTypes();
      JvmTypeReference _typeRef = this.builder.typeRef(matchClass);
      this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
      EList<JvmMember> _members = it.getMembers();
      final Procedure1<JvmConstructor> _function_1 = (JvmConstructor it_1) -> {
        it_1.setSimpleName(innerClassName);
        it_1.setVisibility(JvmVisibility.DEFAULT);
        EList<Variable> _parameters = pattern.getParameters();
        for (final Variable variable : _parameters) {
          {
            final JvmTypeReference javaType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
            EList<JvmFormalParameter> _parameters_1 = it_1.getParameters();
            JvmFormalParameter _parameter = this._eMFJvmTypesBuilder.toParameter(variable, this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable), javaType);
            this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
          }
        }
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("super(");
            {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _hasElements = false;
              for(final Variable variable : _parameters) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(", ", "");
                }
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                _builder.append(_parameterName);
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        this._eMFJvmTypesBuilder.setBody(it_1, _client);
      };
      JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function_1);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
      EList<JvmMember> _members_1 = it.getMembers();
      final Procedure1<JvmOperation> _function_2 = (JvmOperation it_1) -> {
        it_1.setVisibility(JvmVisibility.PUBLIC);
        EList<JvmAnnotationReference> _annotations = it_1.getAnnotations();
        JvmAnnotationReference _annotationRef = this.annBuilder.annotationRef(Override.class);
        this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            _builder.append(isMutable);
            _builder.append(";");
          }
        };
        this._eMFJvmTypesBuilder.setBody(it_1, _client);
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "isMutable", this.builder.typeRef(boolean.class), _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
    };
    return this._eMFJvmTypesBuilder.toClass(pattern, innerClassName, _function);
  }
}
