/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.views.core;

import java.util.Collection;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.views.core.ViewModelRule;
import org.eclipse.viatra.transformation.views.traceability.Traceability;
import org.eclipse.viatra.transformation.views.traceability.TraceabilityFactory;

public class ViewModelManager {
    private static final String TRACEBILITY_RESOURCE = "org.eclipse.viatra.transformation.views.traceability.TraceabilityResource";
    private ViatraQueryEngine engine;
    private ExecutionSchema executionSchema;
    private Collection<ViewModelRule> rules;
    private Traceability traceability = TraceabilityFactory.eINSTANCE.createTraceability();
    private String traceabilityId = UUID.randomUUID().toString();

    public void initialize() {
        this.prepareBaseNotifier();
        this.traceability.setId(this.traceabilityId);
        this.executionSchema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)this.engine, (Scheduler.ISchedulerFactory)Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)this.engine));
        for (ViewModelRule rule : this.rules) {
            rule.initialize(this.traceabilityId);
            rule.getTracedSpecification().getMatcher(this.engine);
            rule.getReferencedSpecification().getMatcher(this.engine);
            rule.getBaseSpecification().getMatcher(this.engine);
            rule.createRuleSpecification(this.executionSchema);
        }
        Logger.getLogger(this.getClass()).info((Object)"View model manager initialized");
        this.executionSchema.startUnscheduledExecution();
        Logger.getLogger(this.getClass()).info((Object)"Unscheduled execution started");
    }

    private void prepareBaseNotifier() {
        Collection<? extends Notifier> notifiers = this.getNotifiers();
        Resource resource = null;
        block0: for (Notifier notifier : notifiers) {
            Resource r;
            if (notifier instanceof Resource && this.checkTraceabilityResource(r = (Resource)notifier)) {
                resource = r;
                break;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            ResourceSet resourceSet = (ResourceSet)notifier;
            for (Resource r2 : resourceSet.getResources()) {
                if (!this.checkTraceabilityResource(r2)) continue;
                resource = r2;
                continue block0;
            }
        }
        if (resource == null) {
            resource = this.addTraceabilityResource();
        }
        resource.getContents().add((Object)this.traceability);
    }

    private boolean checkTraceabilityResource(Resource r) {
        return r.getURI().toString().equals(this.getTraceabilityResourceId());
    }

    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    private Resource addTraceabilityResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)this.getTraceabilityResourceId()));
        NavigationHelper helper = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)this.engine);
        helper.addRoot((Notifier)resourceSet);
        return resource;
    }

    public void setEngine(ViatraQueryEngine engine) {
        if (!(engine.getScope() instanceof EMFScope)) {
            ViatraQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for ViatraQueryEngine");
            return;
        }
        this.engine = engine;
    }

    private Collection<? extends Notifier> getNotifiers() {
        return ((EMFScope)this.engine.getScope()).getScopeRoots();
    }

    public void setRules(Collection<ViewModelRule> rules) {
        this.rules = rules;
    }

    public Traceability getTraceability() {
        return this.traceability;
    }

    public void dispose() {
        this.executionSchema.dispose();
        EcoreUtil.delete((EObject)this.traceability);
    }

    private String getTraceabilityResourceId() {
        return TRACEBILITY_RESOURCE;
    }
}

