/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.menu;

import java.util.List;
import org.eclipse.wb.core.gef.policy.layout.flow.AbstractFlowLayoutEditPolicy;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class MenuLayoutEditPolicy
extends AbstractFlowLayoutEditPolicy {
    private final IMenuInfo m_menu;
    private final IMenuPolicy m_policy;
    private final ILayoutRequestValidator VALIDATOR = new ILayoutRequestValidator(){

        @Override
        public boolean validateCreateRequest(EditPart host, CreateRequest request) {
            return MenuLayoutEditPolicy.this.m_policy.validateCreate(request.getNewObject());
        }

        @Override
        public boolean validatePasteRequest(EditPart host, PasteRequest request) {
            return MenuLayoutEditPolicy.this.m_policy.validatePaste(request.getMemento());
        }

        @Override
        public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
            for (EditPart editPart : request.getEditParts()) {
                if (MenuLayoutEditPolicy.this.m_policy.validateMove(editPart.getModel())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
            return this.validateMoveRequest(host, request);
        }
    };

    public MenuLayoutEditPolicy(IMenuInfo menu) {
        this.m_menu = menu;
        this.m_policy = this.m_menu.getPolicy();
    }

    @Override
    protected boolean isHorizontal(Request request) {
        return this.m_menu.isHorizontal();
    }

    @Override
    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
        return !MenuObjectInfoUtils.isImplicitObject(editPart.getModel());
    }

    @Override
    protected Layer getFeedbackLayer() {
        return this.getLayer("Menu Feedback Layer");
    }

    @Override
    protected Command getCreateCommand(final Object newObject, final Object referenceObject) {
        return new Command(){

            @Override
            public void execute() throws Exception {
                MenuLayoutEditPolicy.this.m_menu.executeEdit(new RunnableEx(){

                    @Override
                    public void run() throws Exception {
                        MenuLayoutEditPolicy.this.m_policy.commandCreate(newObject, referenceObject);
                    }
                });
            }
        };
    }

    @Override
    protected Command getPasteCommand(final PasteRequest request, final Object referenceObject) {
        return new Command(){

            @Override
            public void execute() throws Exception {
                MenuLayoutEditPolicy.this.m_menu.executeEdit(new RunnableEx(){

                    @Override
                    public void run() throws Exception {
                        List<?> pastedObject = MenuLayoutEditPolicy.this.m_policy.commandPaste(request.getMemento(), referenceObject);
                        request.setObjects(pastedObject);
                    }
                });
            }
        };
    }

    @Override
    protected Command getMoveCommand(final Object moveObject, final Object referenceObject) {
        return new Command(){

            @Override
            public void execute() throws Exception {
                MenuLayoutEditPolicy.this.m_menu.executeEdit(new RunnableEx(){

                    @Override
                    public void run() throws Exception {
                        MenuLayoutEditPolicy.this.m_policy.commandMove(moveObject, referenceObject);
                    }
                });
            }
        };
    }

    @Override
    protected ILayoutRequestValidator getRequestValidator() {
        return this.VALIDATOR;
    }
}

