/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public abstract class StackContainerSupport<T extends ObjectInfo> {
    private final ObjectInfo m_container;
    private T m_active;

    public StackContainerSupport(ObjectInfo container) throws Exception {
        this.m_container = container;
        container.addBroadcastListener(new ObjectInfoChildAddAfter(){

            @Override
            public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (!GlobalState.isParsing() && StackContainerSupport.this.isActive() && StackContainerSupport.this.isChild(child)) {
                    StackContainerSupport.this.m_active = StackContainerSupport.this.getCasted(child);
                }
            }
        });
        container.addBroadcastListener(new ObjectEventListener(){

            @Override
            public void childRemoveBefore(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (StackContainerSupport.this.isActive() && child == StackContainerSupport.this.m_active) {
                    List children = StackContainerSupport.this.getChildren();
                    StackContainerSupport.this.m_active = (ObjectInfo)children.get(0);
                    if (StackContainerSupport.this.m_active == child) {
                        StackContainerSupport.this.m_active = children.size() > 1 ? (ObjectInfo)children.get(1) : null;
                    }
                }
            }

            @Override
            public void selecting(ObjectInfo object, boolean[] refreshFlag) throws Exception {
                ObjectInfo child;
                if (StackContainerSupport.this.isActive() && StackContainerSupport.this.getContainer().isParentOf(object) && (child = StackContainerSupport.this.getChild(object)) != null && StackContainerSupport.this.m_active != child) {
                    StackContainerSupport.this.m_active = child;
                    refreshFlag[0] = true;
                }
            }
        });
    }

    public final T getActive() {
        List<T> children;
        if (this.m_active == null && !(children = this.getChildren()).isEmpty()) {
            this.m_active = (ObjectInfo)children.get(0);
        }
        return this.m_active;
    }

    public final void setActive(T active) {
        if (active != this.m_active) {
            this.m_active = active;
            ExecutionUtils.refresh(this.m_container);
        }
    }

    public T getPrev() {
        List<T> children = this.getChildren();
        return (T)((ObjectInfo)GenericsUtils.getPrevOrLast(children, this.m_active));
    }

    public T getNext() {
        List<T> children = this.getChildren();
        return (T)((ObjectInfo)GenericsUtils.getNextOrFirst(children, this.m_active));
    }

    private T getCasted(ObjectInfo o) {
        return (T)o;
    }

    private T getChild(ObjectInfo object) {
        List<T> children = this.getChildren();
        if (children.contains(object)) {
            return this.getCasted(object);
        }
        return object.getParent(children);
    }

    private boolean isChild(ObjectInfo child) {
        return this.getChildren().contains(child);
    }

    protected boolean isActive() {
        return true;
    }

    protected ObjectInfo getContainer() {
        return this.m_container;
    }

    protected abstract List<T> getChildren();
}

