/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;

public class WSDLComponentDescriptionProvider
extends LabelProvider
implements IComponentDescriptionProvider {
    private static final Image BINDING_IMAGE = WSDLEditorPlugin.getInstance().getImage("icons/binding_obj.gif");
    private static final Image PORTTYPE_IMAGE = WSDLEditorPlugin.getInstance().getImage("icons/porttype_obj.gif");
    private static final Image MESSAGE_IMAGE = WSDLEditorPlugin.getInstance().getImage("icons/message_obj.gif");

    public boolean isApplicable(Object component) {
        return true;
    }

    public String getQualifier(Object component) {
        QualifiedName qualifiedName;
        String result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getQualifier();
        } else if (component instanceof WSDLElement) {
            result = ((WSDLElement)component).getEnclosingDefinition().getTargetNamespace();
        } else if (component instanceof SearchMatch && (qualifiedName = this.getQualifiedNameForSearchMatch((SearchMatch)component)) != null) {
            result = qualifiedName.getNamespace();
        }
        return result;
    }

    public String getName(Object component) {
        QualifiedName qualifiedName;
        String result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getName();
        } else if (component instanceof WSDLElement) {
            result = ((WSDLElement)component).getElement().getAttribute("name");
        } else if (component instanceof SearchMatch && (qualifiedName = this.getQualifiedNameForSearchMatch((SearchMatch)component)) != null) {
            result = qualifiedName.getLocalName();
        }
        return result;
    }

    public Image getFileIcon(Object component) {
        return WSDLEditorPlugin.getInstance().getImage("icons/wsdl_file_obj.gif");
    }

    public IFile getFile(Object component) {
        WSDLElement concreteComponent;
        Definition definition;
        IFile result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getFile();
        } else if (component instanceof SearchMatch) {
            result = ((SearchMatch)component).getFile();
        } else if (component instanceof WSDLElement && (definition = (concreteComponent = (WSDLElement)component).getEnclosingDefinition()) != null) {
            String location = definition.getLocation();
            String platformResource = "platform:/resource";
            if (location != null && location.startsWith(platformResource)) {
                Path path = new Path(location.substring(platformResource.length()));
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        return result;
    }

    public ILabelProvider getLabelProvider() {
        return this;
    }

    public String getText(Object element) {
        String result = "";
        String name = this.getName(element);
        if (name != null) {
            result = String.valueOf(result) + name;
        }
        return result;
    }

    public Image getImage(Object component) {
        Image result = null;
        if (component instanceof ComponentSpecification) {
            QualifiedName qualifiedName = ((ComponentSpecification)component).getMetaName();
            if (qualifiedName != null) {
                if (qualifiedName.equals((Object)IWSDLSearchConstants.BINDING_META_NAME)) {
                    result = BINDING_IMAGE;
                } else if (qualifiedName.equals((Object)IWSDLSearchConstants.PORT_TYPE_META_NAME)) {
                    result = PORTTYPE_IMAGE;
                } else if (qualifiedName.equals((Object)IWSDLSearchConstants.MESSAGE_META_NAME)) {
                    result = MESSAGE_IMAGE;
                }
            }
        } else if (component instanceof SearchMatch) {
            SearchMatch searchMatch = (SearchMatch)component;
            QualifiedName qualifiedName = (QualifiedName)searchMatch.map.get("metaName");
            if (qualifiedName != null) {
                if (qualifiedName.equals((Object)IWSDLSearchConstants.BINDING_META_NAME)) {
                    result = BINDING_IMAGE;
                } else if (qualifiedName.equals((Object)IWSDLSearchConstants.PORT_TYPE_META_NAME)) {
                    result = PORTTYPE_IMAGE;
                } else if (qualifiedName.equals((Object)IWSDLSearchConstants.MESSAGE_META_NAME)) {
                    result = MESSAGE_IMAGE;
                }
            }
        } else if (component instanceof Binding) {
            result = BINDING_IMAGE;
        } else if (component instanceof PortType) {
            result = PORTTYPE_IMAGE;
        } else if (component instanceof Message) {
            result = MESSAGE_IMAGE;
        }
        return result;
    }

    private QualifiedName getQualifiedNameForSearchMatch(SearchMatch match) {
        QualifiedName qualifiedName = null;
        Object o = match.map.get("name");
        if (o != null && o instanceof QualifiedName) {
            qualifiedName = (QualifiedName)o;
        }
        return qualifiedName;
    }
}

