/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua;

import com.naef.jnlua.Converter;
import com.naef.jnlua.JavaFunction;
import com.naef.jnlua.JavaReflector;
import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.LuaType;
import com.naef.jnlua.TypedJavaObject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultJavaReflector
implements JavaReflector {
    private static final DefaultJavaReflector INSTANCE = new DefaultJavaReflector();
    private static final Object JAVA_FUNCTION_TYPE = new Object();
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private Map<Class<?>, Map<String, Accessor>> accessors = new HashMap();
    private ReadWriteLock accessorLock = new ReentrantReadWriteLock();
    private Map<LuaCallSignature, Invocable> invocableDispatches = new HashMap<LuaCallSignature, Invocable>();
    private ReadWriteLock invocableDispatchLock = new ReentrantReadWriteLock();
    private JavaFunction index = new Index();
    private JavaFunction newIndex = new NewIndex();
    private JavaFunction equal = new Equal();
    private JavaFunction length = new Length();
    private JavaFunction lessThan = new LessThan();
    private JavaFunction lessThanOrEqual = new LessThanOrEqual();
    private JavaFunction toString = new ToString();
    private JavaFunction javaFields = new AccessorPairs(FieldAccessor.class);
    private JavaFunction javaMethods = new AccessorPairs(InvocableAccessor.class);
    private JavaFunction javaProperties = new AccessorPairs(PropertyAccessor.class);

    public static DefaultJavaReflector getInstance() {
        return INSTANCE;
    }

    private DefaultJavaReflector() {
    }

    @Override
    public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
        switch (metamethod) {
            case INDEX: {
                return this.index;
            }
            case NEWINDEX: {
                return this.newIndex;
            }
            case EQ: {
                return this.equal;
            }
            case LEN: {
                return this.length;
            }
            case LT: {
                return this.lessThan;
            }
            case LE: {
                return this.lessThanOrEqual;
            }
            case TOSTRING: {
                return this.toString;
            }
            case JAVAFIELDS: {
                return this.javaFields;
            }
            case JAVAMETHODS: {
                return this.javaMethods;
            }
            case JAVAPROPERTIES: {
                return this.javaProperties;
            }
        }
        return null;
    }

    private Map<String, Accessor> getObjectAccessors(Object object) {
        Map<String, Accessor> result;
        Class<?> clazz = this.getObjectClass(object);
        this.accessorLock.readLock().lock();
        try {
            result = this.accessors.get(clazz);
            if (result != null) {
                Map<String, Accessor> map = result;
                return map;
            }
        }
        finally {
            this.accessorLock.readLock().unlock();
        }
        result = this.createClassAccessors(clazz);
        this.accessorLock.writeLock().lock();
        try {
            if (!this.accessors.containsKey(clazz)) {
                this.accessors.put(clazz, result);
            } else {
                result = this.accessors.get(clazz);
            }
        }
        finally {
            this.accessorLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Accessor> createClassAccessors(Class<?> clazz) {
        BeanInfo beanInfo;
        void var6_8;
        HashMap<String, Accessor> result = new HashMap<String, Accessor>();
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            result.put(fields[i].getName(), new FieldAccessor(fields[i]));
            ++i;
        }
        HashMap accessibleMethods = new HashMap();
        Method[] methods = clazz.getMethods();
        boolean bl = false;
        while (var6_8 < methods.length) {
            Object method = methods[var6_8];
            if (!result.containsKey(((Method)method).getName()) && (Modifier.isPublic(((Method)method).getDeclaringClass().getModifiers()) || (method = this.getInterfaceMethod(clazz, ((Method)method).getName(), ((Method)method).getParameterTypes())) != null)) {
                List<Class<?>> parameterTypes;
                Invocable currentInvocable;
                HashMap overloaded = (HashMap)accessibleMethods.get(((Method)method).getName());
                if (overloaded == null) {
                    overloaded = new HashMap();
                    accessibleMethods.put(((Method)method).getName(), overloaded);
                }
                if ((currentInvocable = (Invocable)overloaded.get(parameterTypes = Arrays.asList(((Method)method).getParameterTypes()))) == null || !((Method)method).getDeclaringClass().isAssignableFrom(currentInvocable.getDeclaringClass())) {
                    overloaded.put(parameterTypes, new InvocableMethod((Method)method));
                }
            }
            ++var6_8;
        }
        for (Map.Entry entry : accessibleMethods.entrySet()) {
            result.put((String)entry.getKey(), new InvocableAccessor(clazz, ((Map)entry.getValue()).values()));
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        ArrayList<Invocable> accessibleConstructors = new ArrayList<Invocable>(constructorArray.length);
        int i3 = 0;
        while (i3 < constructorArray.length) {
            if (Modifier.isPublic(constructorArray[i3].getDeclaringClass().getModifiers())) {
                accessibleConstructors.add(new InvocableConstructor(constructorArray[i3]));
            }
            ++i3;
        }
        result.put("new", new InvocableAccessor(clazz, accessibleConstructors));
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i4 = 0;
        while (i4 < propertyDescriptors.length) {
            if (!result.containsKey(propertyDescriptors[i4].getName())) {
                Method method = propertyDescriptors[i4].getReadMethod();
                if (method != null && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method = this.getInterfaceMethod(clazz, method.getName(), method.getParameterTypes());
                    try {
                        propertyDescriptors[i4].setReadMethod(method);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
                if ((method = propertyDescriptors[i4].getWriteMethod()) != null && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method = this.getInterfaceMethod(clazz, method.getName(), method.getParameterTypes());
                    try {
                        propertyDescriptors[i4].setWriteMethod(method);
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
                if (propertyDescriptors[i4].getReadMethod() != null || propertyDescriptors[i4].getWriteMethod() != null) {
                    result.put(propertyDescriptors[i4].getName(), new PropertyAccessor(clazz, propertyDescriptors[i4]));
                }
            }
            ++i4;
        }
        return result;
    }

    private Method getInterfaceMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        do {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                block5: {
                    if (Modifier.isPublic(interfaces[i].getModifiers())) {
                        try {
                            return interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Method method = this.getInterfaceMethod(interfaces[i], methodName, parameterTypes);
                            if (method == null) break block5;
                            return method;
                        }
                    }
                }
                ++i;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private Class<?> getObjectClass(Object object) {
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    private static interface Accessor {
        public void read(LuaState var1, Object var2);

        public void write(LuaState var1, Object var2);

        public boolean isNotStatic();

        public boolean isStatic();
    }

    private class AccessorPairs
    implements JavaFunction {
        private Class<?> accessorClass;

        public AccessorPairs(Class<?> accessorClass) {
            this.accessorClass = accessorClass;
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            Iterator<Map.Entry<String, Accessor>> iterator = objectAccessors.entrySet().iterator();
            luaState.pushJavaObject(new AccessorNext(iterator, objectClass == object));
            luaState.pushJavaObject(object);
            luaState.pushNil();
            return 3;
        }

        private class AccessorNext
        implements JavaFunction {
            private Iterator<Map.Entry<String, Accessor>> iterator;
            private boolean isStatic;

            public AccessorNext(Iterator<Map.Entry<String, Accessor>> iterator, boolean isStatic) {
                this.iterator = iterator;
                this.isStatic = isStatic;
            }

            @Override
            public int invoke(LuaState luaState) {
                while (this.iterator.hasNext()) {
                    Map.Entry<String, Accessor> entry = this.iterator.next();
                    Accessor accessor = entry.getValue();
                    if (accessor.getClass() != AccessorPairs.this.accessorClass || (this.isStatic ? !accessor.isStatic() : !accessor.isNotStatic())) continue;
                    luaState.pushString(entry.getKey());
                    Object object = luaState.toJavaObject(1, Object.class);
                    accessor.read(luaState, object);
                    return 2;
                }
                return 0;
            }
        }
    }

    private static class Equal
    implements JavaFunction {
        private Equal() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object2;
            Object object1 = luaState.toJavaObject(1, Object.class);
            luaState.pushBoolean(object1 == (object2 = luaState.toJavaObject(2, Object.class)) || object1 != null && object1.equals(object2));
            return 1;
        }
    }

    private class FieldAccessor
    implements Accessor {
        private Field field;

        public FieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public void read(LuaState luaState, Object object) {
            try {
                Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
                if (objectClass == object) {
                    object = null;
                }
                luaState.pushJavaObject(this.field.get(object));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(LuaState luaState, Object object) {
            try {
                Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
                if (objectClass == object) {
                    object = null;
                }
                Object value = luaState.checkJavaObject(-1, this.field.getType());
                this.field.set(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isNotStatic() {
            return !Modifier.isStatic(this.field.getModifiers());
        }

        @Override
        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }
    }

    private class Index
    implements JavaFunction {
        private Index() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass.isArray()) {
                if (!luaState.isNumber(2)) {
                    throw new LuaRuntimeException(String.format("attempt to read array with %s accessor", luaState.typeName(2)));
                }
                int index = luaState.toInteger(2);
                int length = Array.getLength(object);
                if (index < 1 || index > length) {
                    throw new LuaRuntimeException(String.format("attempt to read array of length %d at index %d", length, index));
                }
                luaState.pushJavaObject(Array.get(object, index - 1));
                return 1;
            }
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            String key = luaState.toString(-1);
            if (key == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with %s accessor", object.getClass().getCanonicalName(), luaState.typeName(-1)));
            }
            Accessor accessor = (Accessor)objectAccessors.get(key);
            if (accessor == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with accessor '%s' (undefined)", objectClass.getCanonicalName(), key));
            }
            accessor.read(luaState, object);
            return 1;
        }
    }

    private static interface Invocable {
        public String getWhat();

        public Class<?> getDeclaringClass();

        public int getModifiers();

        public String getName();

        public Class<?> getReturnType();

        public int getParameterCount();

        public Class<?>[] getParameterTypes();

        public Class<?> getParameterType(int var1);

        public boolean isVarArgs();

        public Object invoke(Object var1, Object ... var2) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }

    private class InvocableAccessor
    implements Accessor,
    JavaFunction {
        private Class<?> clazz;
        private List<Invocable> invocables;

        public InvocableAccessor(Class<?> clazz, Collection<Invocable> invocables) {
            this.clazz = clazz;
            this.invocables = new ArrayList<Invocable>(invocables);
        }

        public String getName() {
            return this.invocables.get(0).getName();
        }

        public String getWhat() {
            return this.invocables.get(0).getWhat();
        }

        @Override
        public void read(LuaState luaState, Object object) {
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass == object) {
                object = null;
            }
            luaState.pushJavaFunction(this);
        }

        @Override
        public void write(LuaState luaState, Object object) {
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            throw new LuaRuntimeException(String.format("attempt to write class %s with accessor '%s' (a %s)", objectClass.getCanonicalName(), this.getName(), this.getWhat()));
        }

        @Override
        public boolean isNotStatic() {
            for (Invocable invocable : this.invocables) {
                if (Modifier.isStatic(invocable.getModifiers())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isStatic() {
            for (Invocable invocable : this.invocables) {
                if (!Modifier.isStatic(invocable.getModifiers())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int invoke(LuaState luaState) {
            Object result;
            int i;
            Invocable invocable;
            Object object = luaState.checkJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            luaState.checkArg(1, this.clazz.isAssignableFrom(objectClass), String.format("class %s is not a subclass of %s", objectClass.getCanonicalName(), this.clazz.getCanonicalName()));
            if (objectClass == object) {
                object = null;
            }
            LuaCallSignature luaCallSignature = this.getLuaCallSignature(luaState);
            DefaultJavaReflector.this.invocableDispatchLock.readLock().lock();
            try {
                invocable = (Invocable)DefaultJavaReflector.this.invocableDispatches.get(luaCallSignature);
            }
            finally {
                DefaultJavaReflector.this.invocableDispatchLock.readLock().unlock();
            }
            if (invocable == null) {
                invocable = this.dispatchInvocable(luaState, object == null);
                DefaultJavaReflector.this.invocableDispatchLock.writeLock().lock();
                try {
                    if (!DefaultJavaReflector.this.invocableDispatches.containsKey(luaCallSignature)) {
                        DefaultJavaReflector.this.invocableDispatches.put(luaCallSignature, invocable);
                    } else {
                        invocable = (Invocable)DefaultJavaReflector.this.invocableDispatches.get(luaCallSignature);
                    }
                }
                finally {
                    DefaultJavaReflector.this.invocableDispatchLock.writeLock().unlock();
                }
            }
            int argCount = luaState.getTop() - 1;
            int parameterCount = invocable.getParameterCount();
            Object[] arguments = new Object[parameterCount];
            if (invocable.isVarArgs()) {
                i = 0;
                while (i < parameterCount - 1) {
                    arguments[i] = luaState.toJavaObject(i + 2, invocable.getParameterType(i));
                    ++i;
                }
                arguments[parameterCount - 1] = Array.newInstance(invocable.getParameterType(parameterCount - 1), argCount - (parameterCount - 1));
                i = parameterCount - 1;
                while (i < argCount) {
                    Array.set(arguments[parameterCount - 1], i - (parameterCount - 1), luaState.toJavaObject(i + 2, invocable.getParameterType(i)));
                    ++i;
                }
            } else {
                i = 0;
                while (i < parameterCount) {
                    arguments[i] = luaState.toJavaObject(i + 2, invocable.getParameterType(i));
                    ++i;
                }
            }
            try {
                result = invocable.invoke(object, arguments);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            if (invocable.getReturnType() != Void.TYPE) {
                luaState.pushJavaObject(result);
                return 1;
            }
            return 0;
        }

        private LuaCallSignature getLuaCallSignature(LuaState luaState) {
            int argCount = luaState.getTop() - 1;
            Object[] types = new Object[argCount];
            int i = 0;
            while (i < argCount) {
                LuaType type = luaState.type(i + 2);
                switch (type) {
                    case FUNCTION: {
                        types[i] = luaState.isJavaFunction(i + 2) ? JAVA_FUNCTION_TYPE : LuaType.FUNCTION;
                        break;
                    }
                    case USERDATA: {
                        if (luaState.isJavaObjectRaw(i + 2)) {
                            Object object = luaState.toJavaObjectRaw(i + 2);
                            if (object instanceof TypedJavaObject) {
                                types[i] = ((TypedJavaObject)object).getType();
                                break;
                            }
                            types[i] = object.getClass();
                            break;
                        }
                        types[i] = LuaType.USERDATA;
                        break;
                    }
                    default: {
                        types[i] = type;
                    }
                }
                ++i;
            }
            return new LuaCallSignature(this.clazz, this.getName(), types);
        }

        private Invocable dispatchInvocable(LuaState luaState, boolean staticDispatch) {
            int j;
            boolean delta;
            int parameterCount;
            Invocable invocable;
            HashSet<Invocable> candidates = new HashSet<Invocable>(this.invocables);
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                Invocable invocable2 = (Invocable)i.next();
                if (Modifier.isStatic(invocable2.getModifiers()) == staticDispatch) continue;
                i.remove();
            }
            int argCount = luaState.getTop() - 1;
            Iterator i2 = candidates.iterator();
            while (i2.hasNext()) {
                Invocable invocable3 = (Invocable)i2.next();
                if (invocable3.isVarArgs()) {
                    if (argCount >= invocable3.getParameterCount() - 1) continue;
                    i2.remove();
                    continue;
                }
                if (argCount == invocable3.getParameterCount()) continue;
                i2.remove();
            }
            Converter converter = luaState.getConverter();
            Iterator i3 = candidates.iterator();
            block2: while (i3.hasNext()) {
                Invocable invocable4 = (Invocable)i3.next();
                int j2 = 0;
                while (j2 < argCount) {
                    int distance = converter.getTypeDistance(luaState, j2 + 2, invocable4.getParameterType(j2));
                    if (distance == Integer.MAX_VALUE) {
                        i3.remove();
                        continue block2;
                    }
                    ++j2;
                }
            }
            boolean haveFixArgs = false;
            boolean haveVarArgs = false;
            for (Invocable invocable5 : candidates) {
                haveFixArgs = haveFixArgs || !invocable5.isVarArgs();
                boolean bl = haveVarArgs = haveVarArgs || invocable5.isVarArgs();
            }
            if (haveVarArgs && haveFixArgs) {
                Iterator i4 = candidates.iterator();
                while (i4.hasNext()) {
                    invocable = (Invocable)i4.next();
                    if (!invocable.isVarArgs()) continue;
                    i4.remove();
                }
            }
            Iterator i5 = candidates.iterator();
            block6: while (i5.hasNext()) {
                invocable = (Invocable)i5.next();
                block7: for (Invocable other : candidates) {
                    if (other == invocable) continue;
                    parameterCount = Math.min(argCount, Math.max(invocable.getParameterCount(), other.getParameterCount()));
                    delta = false;
                    j = 0;
                    while (j < parameterCount) {
                        int distance = converter.getTypeDistance(luaState, j + 2, invocable.getParameterType(j));
                        int otherDistance = converter.getTypeDistance(luaState, j + 2, other.getParameterType(j));
                        if (otherDistance > distance) continue block7;
                        delta = delta || distance != otherDistance;
                        ++j;
                    }
                    if (!delta) continue;
                    i5.remove();
                    continue block6;
                }
            }
            i5 = candidates.iterator();
            block9: while (i5.hasNext()) {
                invocable = (Invocable)i5.next();
                block10: for (Invocable other : candidates) {
                    if (other == invocable) continue;
                    parameterCount = Math.min(argCount, Math.max(invocable.getParameterCount(), other.getParameterCount()));
                    delta = false;
                    j = 0;
                    while (j < parameterCount) {
                        Class<?> otherType;
                        Class<?> type = invocable.getParameterType(j);
                        if (!type.isAssignableFrom(otherType = other.getParameterType(j))) continue block10;
                        delta = delta || type != otherType;
                        ++j;
                    }
                    if (!delta) continue;
                    i5.remove();
                    continue block9;
                }
            }
            if (candidates.isEmpty()) {
                throw this.getSignatureMismatchException(luaState);
            }
            if (candidates.size() > 1) {
                throw this.getSignatureAmbivalenceException(luaState, candidates);
            }
            return (Invocable)candidates.iterator().next();
        }

        private LuaRuntimeException getSignatureMismatchException(LuaState luaState) {
            return new LuaRuntimeException(String.format("no %s of class %s matches '%s(%s)'", this.getWhat(), this.clazz.getCanonicalName(), this.getName(), this.getLuaSignatureString(luaState)));
        }

        private LuaRuntimeException getSignatureAmbivalenceException(LuaState luaState, Set<Invocable> candidates) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("%s '%s(%s)' on class %s is ambivalent among ", this.getWhat(), this.getName(), this.getLuaSignatureString(luaState), this.clazz.getCanonicalName()));
            boolean first = true;
            for (Invocable invocable : candidates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(String.format("'%s(%s)'", this.getName(), this.getJavaSignatureString(invocable.getParameterTypes())));
            }
            return new LuaRuntimeException(sb.toString());
        }

        private String getLuaSignatureString(LuaState luaState) {
            int argCount = luaState.getTop() - 1;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < argCount) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(luaState.typeName(i + 2));
                ++i;
            }
            return sb.toString();
        }

        private String getJavaSignatureString(Class<?>[] types) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < types.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(types[i].getCanonicalName());
                ++i;
            }
            return sb.toString();
        }
    }

    private static class InvocableConstructor
    implements Invocable {
        private Constructor<?> constructor;
        private Class<?>[] parameterTypes;

        public InvocableConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameterTypes = constructor.getParameterTypes();
        }

        @Override
        public String getWhat() {
            return "constructor";
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers() | 8;
        }

        @Override
        public String getName() {
            return "new";
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getParameterType(int index) {
            if (this.constructor.isVarArgs() && index >= this.parameterTypes.length - 1) {
                return this.parameterTypes[this.parameterTypes.length - 1].getComponentType();
            }
            return this.parameterTypes[index];
        }

        @Override
        public boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.constructor.newInstance(args);
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    private static class InvocableMethod
    implements Invocable {
        private Method method;
        private Class<?>[] parameterTypes;

        public InvocableMethod(Method method) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
        }

        @Override
        public String getWhat() {
            return "method";
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getParameterType(int index) {
            if (this.method.isVarArgs() && index >= this.parameterTypes.length - 1) {
                return this.parameterTypes[this.parameterTypes.length - 1].getComponentType();
            }
            return this.parameterTypes[index];
        }

        @Override
        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(obj, args);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private static class Length
    implements JavaFunction {
        private Length() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            if (object.getClass().isArray()) {
                luaState.pushInteger(Array.getLength(object));
                return 1;
            }
            luaState.pushInteger(0);
            return 1;
        }
    }

    private static class LessThan
    implements JavaFunction {
        private LessThan() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (!luaState.isJavaObject(1, Comparable.class)) {
                throw new LuaRuntimeException(String.format("class %s does not implement Comparable", luaState.typeName(1)));
            }
            Comparable comparable = luaState.toJavaObject(1, Comparable.class);
            luaState.pushBoolean(comparable.compareTo(object = luaState.toJavaObject(2, Object.class)) < 0);
            return 1;
        }
    }

    private static class LessThanOrEqual
    implements JavaFunction {
        private LessThanOrEqual() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            if (!luaState.isJavaObject(1, Comparable.class)) {
                throw new LuaRuntimeException(String.format("class %s does not implement Comparable", luaState.typeName(1)));
            }
            Comparable comparable = luaState.toJavaObject(1, Comparable.class);
            luaState.pushBoolean(comparable.compareTo(object = luaState.toJavaObject(2, Object.class)) <= 0);
            return 1;
        }
    }

    private static class LuaCallSignature {
        private Class<?> clazz;
        private String invocableName;
        private Object[] types;
        private int hashCode;

        public LuaCallSignature(Class<?> clazz, String invocableName, Object[] types) {
            this.clazz = clazz;
            this.invocableName = invocableName;
            this.types = types;
            this.hashCode = clazz.hashCode();
            this.hashCode = this.hashCode * 65599 + invocableName.hashCode();
            int i = 0;
            while (i < types.length) {
                this.hashCode = this.hashCode * 65599 + types[i].hashCode();
                ++i;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LuaCallSignature)) {
                return false;
            }
            LuaCallSignature other = (LuaCallSignature)obj;
            if (this.clazz != other.clazz || !this.invocableName.equals(other.invocableName) || this.types.length != other.types.length) {
                return false;
            }
            int i = 0;
            while (i < this.types.length) {
                if (this.types[i] != other.types[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.clazz.getCanonicalName()) + ": " + this.invocableName + "(" + Arrays.asList(this.types) + ")";
        }
    }

    private class NewIndex
    implements JavaFunction {
        private NewIndex() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            Class objectClass = DefaultJavaReflector.this.getObjectClass(object);
            if (objectClass.isArray()) {
                if (!luaState.isNumber(2)) {
                    throw new LuaRuntimeException(String.format("attempt to write array with %s accessor", luaState.typeName(2)));
                }
                int index = luaState.toInteger(2);
                int length = Array.getLength(object);
                if (index < 1 || index > length) {
                    throw new LuaRuntimeException(String.format("attempt to write array of length %d at index %d", length, index));
                }
                Class<?> componentType = objectClass.getComponentType();
                if (!luaState.isJavaObject(3, componentType)) {
                    throw new LuaRuntimeException(String.format("attempt to write array of %s at index %d with %s value", componentType.getCanonicalName(), index, luaState.typeName(3)));
                }
                Object value = luaState.toJavaObject(3, componentType);
                Array.set(object, index - 1, value);
                return 0;
            }
            Map objectAccessors = DefaultJavaReflector.this.getObjectAccessors(object);
            String key = luaState.toString(2);
            if (key == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with %s accessor", object.getClass().getCanonicalName(), luaState.typeName(2)));
            }
            Accessor accessor = (Accessor)objectAccessors.get(key);
            if (accessor == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with accessor '%s' (undefined)", objectClass.getCanonicalName(), key));
            }
            accessor.write(luaState, object);
            return 0;
        }
    }

    private class PropertyAccessor
    implements Accessor {
        private Class<?> clazz;
        private PropertyDescriptor propertyDescriptor;

        public PropertyAccessor(Class<?> clazz, PropertyDescriptor propertyDescriptor) {
            this.clazz = clazz;
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        public void read(LuaState luaState, Object object) {
            if (this.propertyDescriptor.getReadMethod() == null) {
                throw new LuaRuntimeException(String.format("attempt to read class %s with accessor '%s' (a write-only property)", this.clazz.getCanonicalName(), this.propertyDescriptor.getName()));
            }
            try {
                luaState.pushJavaObject(this.propertyDescriptor.getReadMethod().invoke(object, EMPTY_ARGUMENTS));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
        }

        @Override
        public void write(LuaState luaState, Object object) {
            if (this.propertyDescriptor.getWriteMethod() == null) {
                throw new LuaRuntimeException(String.format("attempt to write class %s with acessor '%s' (a read-only property)", this.clazz.getCanonicalName(), this.propertyDescriptor.getName()));
            }
            try {
                Object value = luaState.checkJavaObject(-1, this.propertyDescriptor.getPropertyType());
                this.propertyDescriptor.getWriteMethod().invoke(object, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            luaState.pop(1);
        }

        @Override
        public boolean isNotStatic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static class ToString
    implements JavaFunction {
        private ToString() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object = luaState.toJavaObject(1, Object.class);
            luaState.pushString(object != null ? object.toString() : "null");
            return 1;
        }
    }
}

