/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ChoiceSetFactory;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.FilterConditionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;

public final class DataSetFiltersPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private transient PropertyHandleTableViewer viewer = null;
    private transient DataSetViewData[] columns = null;
    private transient String[] columnExpressions = null;
    private transient PropertyHandle filters = null;
    private boolean modelChanged = true;
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.expression"), Messages.getString((String)"dataset.editor.title.operator"), Messages.getString((String)"dataset.editor.title.value1"), Messages.getString((String)"dataset.editor.title.value2")};
    private static String[] operators;
    private static String[] operatorDisplayNames;

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
        IChoice[] chs = chset.getChoices();
        operators = new String[chs.length];
        operatorDisplayNames = new String[chs.length];
        int i = 0;
        while (i < chs.length) {
            DataSetFiltersPage.operators[i] = chs[i].getName();
            DataSetFiltersPage.operatorDisplayNames[i] = chs[i].getDisplayName();
            ++i;
        }
    }

    public Control createContents(Composite parent) {
        this.initColumnNames();
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[0]);
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[1]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[2]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[3]);
        column.setWidth(100);
        this.initializeFilters();
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList filterList = new ArrayList(10);
                Iterator iter = DataSetFiltersPage.this.filters.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        filterList.add(iter.next());
                    }
                }
                return filterList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new FilterTableProvider());
        this.viewer.getViewer().setInput((Object)this.filters);
        this.addListeners();
        this.setToolTips();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetFiltersPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        this.doEdit(new FilterCondition());
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        FilterConditionHandle handle = (FilterConditionHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        FilterConditionBuilder dlg = new FilterConditionBuilder(((DataSetEditor)this.getContainer()).getShell(), this.getTitle(structureOrHandle), this.getTitle(structureOrHandle));
        dlg.setDataSetHandle((DataSetHandle)this.getContainer().getModel(), (IExpressionProvider)new DataSetExpressionProvider((DesignElementHandle)((DataSetHandle)this.getContainer().getModel())));
        dlg.showUpdateAggregationButton(false);
        dlg.setBindingParams(this.getParamBindingHandleArray());
        dlg.setInput(structureOrHandle);
        if (dlg.open() == 0) {
            this.update(structureOrHandle);
        }
    }

    private ParamBindingHandle[] getParamBindingHandleArray() {
        Iterator parameters = ((DataSetHandle)this.getContainer().getModel()).paramBindingsIterator();
        ArrayList params = new ArrayList();
        while (parameters.hasNext()) {
            params.add(parameters.next());
        }
        ParamBindingHandle[] bindingParams = new ParamBindingHandle[params.size()];
        int i = 0;
        while (i < bindingParams.length) {
            bindingParams[i] = (ParamBindingHandle)params.get(i);
            ++i;
        }
        return bindingParams;
    }

    private String getTitle(Object structureOrHandle) {
        if (structureOrHandle instanceof FilterCondition) {
            return Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
        }
        return Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    }

    private void update(Object structureOrHandle) {
        if (structureOrHandle instanceof FilterCondition) {
            this.viewer.getViewer().refresh();
        } else {
            this.viewer.getViewer().update(structureOrHandle, null);
        }
    }

    private FilterCondition getStructure(Object structureOrHandle) {
        FilterCondition structure = null;
        structure = structureOrHandle instanceof FilterCondition ? (FilterCondition)structureOrHandle : (FilterCondition)((FilterConditionHandle)structureOrHandle).getStructure();
        return structure;
    }

    private String getOperatorDisplayName(String name) {
        int i = 0;
        while (i < operators.length) {
            if (operators[i].equals(name)) {
                return operatorDisplayNames[i];
            }
            ++i;
        }
        return operatorDisplayNames[0];
    }

    public boolean canLeave() {
        if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
            this.modelChanged = false;
            ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
        }
        return true;
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return this.canLeave();
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Edit"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Down"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Up"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Remove"));
    }

    private void initColumnNames() {
        try {
            this.columns = ((DataSetEditor)this.getContainer()).getCurrentItemModel(true);
            if (this.columns != null) {
                this.columnExpressions = new String[this.columns.length];
                int n = 0;
                while (n < this.columns.length) {
                    this.columnExpressions[n] = this.columns[n].getName();
                    ++n;
                }
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    private void initializeFilters() {
        this.filters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("filter");
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.filters"), 0);
        this.initializeFilters();
        this.initColumnNames();
        this.setPageProperties();
        this.viewer.getViewer().setInput((Object)this.filters);
        this.viewer.getViewer().getTable().select(0);
    }

    private void setPageProperties() {
        boolean filterConditionExists = false;
        filterConditionExists = this.filters != null && this.filters.getListValue() != null && this.filters.getListValue().size() > 0;
        this.viewer.getEditButton().setEnabled(filterConditionExists);
        this.viewer.getDownButton().setVisible(false);
        this.viewer.getUpButton().setVisible(false);
        this.viewer.getRemoveButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveMenuItem().setEnabled(filterConditionExists);
        this.viewer.getRemoveAllMenuItem().setEnabled(filterConditionExists);
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetFiltersPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetFiltersPage.Filter.Tooltip");
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    private class FilterTableProvider
    implements ITableLabelProvider {
        private FilterTableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            FilterCondition filterCondition = DataSetFiltersPage.this.getStructure(element);
            try {
                switch (columnIndex) {
                    case 0: {
                        value = filterCondition.getExpr();
                        break;
                    }
                    case 1: {
                        value = DataSetFiltersPage.this.getOperatorDisplayName(filterCondition.getOperator());
                        break;
                    }
                    case 2: {
                        value = this.getValue1String(filterCondition);
                        break;
                    }
                    case 3: {
                        value = filterCondition.getValue2();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        private String getValue1String(FilterCondition filterCondition) {
            if ("in".equals(filterCondition.getOperator()) || "not-in".equals(filterCondition.getOperator())) {
                List value1List = filterCondition.getValue1List();
                StringBuffer buf = new StringBuffer();
                for (String value : value1List) {
                    buf.append(String.valueOf(value) + "; ");
                }
                if (buf.length() > 1) {
                    buf.delete(buf.length() - 2, buf.length());
                }
                return buf.toString();
            }
            return filterCondition.getValue1();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetFiltersPage.this.setPageProperties();
        }
    }
}

