/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInputDialog;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteResourceAction
extends ResourceAction {
    private final Clipboard clipboard;

    public PasteResourceAction(LibraryExplorerTreeViewPage page, Clipboard clipboard) {
        super(Messages.getString((String)"PasteLibraryAction.Text"), page);
        this.clipboard = clipboard;
        this.setId(ActionFactory.PASTE.getId());
        this.setAccelerator(262230);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public boolean isEnabled() {
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null && fileData.length > 0) {
            try {
                return this.canInsertIntoSelectedContainer();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public void run() {
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null && fileData.length > 0) {
            File container;
            try {
                container = this.getSelectedContainer();
            }
            catch (IOException e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            if (container == null) {
                return;
            }
            String[] stringArray = fileData;
            int n = fileData.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                File srcFile = new File(filename);
                File targetFile = new File(container, srcFile.getName());
                if (targetFile.exists()) {
                    String[] existedNames = container.list();
                    RenameInputDialog inputDialog = new RenameInputDialog(this.getShell(), Messages.getString((String)"PasteResourceAction.Dialog.Title"), Messages.getString((String)"PasteResourceAction.Dialog.Message"), String.valueOf(Messages.getString((String)"PasteResourceAction.Dialog.FilenameSuffix.CopyOf")) + " " + srcFile.getName(), existedNames, "org.eclipse.birt.cshelp.RenameInputDialog_ID");
                    inputDialog.create();
                    if (inputDialog.open() == 0) {
                        targetFile = new File(container, inputDialog.getResult().toString().trim());
                    } else {
                        return;
                    }
                }
                this.doCopy(srcFile, targetFile);
                ++n2;
            }
        }
    }

    private void doCopy(File srcFile, File targetFile) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, this.createCopyFileRunnable(srcFile, targetFile));
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }
}

