/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PreviewLabel
extends Canvas {
    protected static final int WEIGHT_NORMAL = 400;
    protected static final int WEIGHT_BOLD = 700;
    private String text;
    private boolean isUnderline;
    private boolean isLinethrough;
    private boolean isOverline;
    private String fontFamily = "Times New Roman";
    private int fontSize = 9;
    private int fontWeight = 400;
    private boolean isBold;
    private boolean isItalic;
    private boolean updateOnTheFly;
    private boolean fontCreated;

    public PreviewLabel(Composite parent, int style) {
        super(parent, style);
        this.initFields();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PreviewLabel.this.paintControl(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PreviewLabel.this.fontCreated) {
                    PreviewLabel.this.getFont().dispose();
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                e.doit = true;
            }
        });
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = PreviewLabel.this.toControl(new Point(e.x, e.y));
                e.childID = PreviewLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = PreviewLabel.this.getBounds();
                Point pt = PreviewLabel.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = PreviewLabel.this.text;
            }
        });
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = PreviewLabel.this.text;
                if (e.result == null) {
                    this.getHelp(e);
                }
            }

            public void getHelp(AccessibleEvent e) {
                e.result = PreviewLabel.this.getToolTipText();
            }
        });
    }

    private void initFields() {
        try {
            FontData fd = this.getFont().getFontData()[0];
            this.fontFamily = fd.getName();
            this.fontSize = fd.getHeight();
            this.isBold = (fd.getStyle() & 1) != 0;
            this.isItalic = (fd.getStyle() & 2) != 0;
        }
        catch (Exception exception) {}
    }

    public void restoreDefaultState() {
        this.isUnderline = false;
        this.isLinethrough = false;
        this.isOverline = false;
        this.fontFamily = "Times New Roman";
        this.fontSize = 9;
        this.fontWeight = 400;
        this.isBold = false;
        this.isItalic = false;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void setUpdateOnthefly(boolean onthefly) {
        this.updateOnTheFly = onthefly;
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public void setUnderline(boolean underline) {
        this.isUnderline = underline;
    }

    public void setLinethrough(boolean linethrough) {
        this.isLinethrough = linethrough;
    }

    public void setOverline(boolean overline) {
        this.isOverline = overline;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void setFontWeight(int fontWeight) {
        this.fontWeight = fontWeight;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
        int n = this.fontWeight = isBold ? 700 : 400;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
        if (this.updateOnTheFly) {
            this.updateView();
        }
    }

    public void updateView() {
        Font oldFont = this.getFont();
        int style = 0;
        if (this.isBold) {
            style |= 1;
        }
        if (this.isItalic) {
            style |= 2;
        }
        if (this.fontWeight >= 700) {
            style |= 1;
        }
        this.setFont(new Font((Device)Display.getCurrent(), this.fontFamily, this.fontSize, style));
        if (this.fontCreated) {
            oldFont.dispose();
        }
        this.fontCreated = true;
        this.redraw();
    }

    protected void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.text == null) {
            this.text = "";
        }
        Point pt = gc.stringExtent(this.text);
        gc.drawString(this.text, (this.getSize().x - pt.x) / 2, (this.getSize().y - pt.y) / 2, true);
        if (this.isUnderline) {
            gc.drawLine((this.getSize().x - pt.x) / 2, (this.getSize().y - pt.y) / 2 + pt.y, (this.getSize().x - pt.x) / 2 + pt.x, (this.getSize().y - pt.y) / 2 + pt.y);
        }
        if (this.isLinethrough) {
            gc.drawLine((this.getSize().x - pt.x) / 2, (this.getSize().y - pt.y) / 2 + pt.y / 2, (this.getSize().x - pt.x) / 2 + pt.x, (this.getSize().y - pt.y) / 2 + pt.y / 2);
        }
        if (this.isOverline) {
            gc.drawLine((this.getSize().x - pt.x) / 2, (this.getSize().y - pt.y) / 2, (this.getSize().x - pt.x) / 2 + pt.x, (this.getSize().y - pt.y) / 2);
        }
    }
}

