/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.DeleteLinkCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.gef.commands.Command;

public class RevalidateLinksCommand
extends AutoUndoCommand {
    List<Activity> activities;
    CompoundCommand deleteLinksCmd;

    public RevalidateLinksCommand(Collection activityCollection) {
        super(new ArrayList<Object>(1));
        this.activities = new ArrayList<Activity>(activityCollection.size());
        this.activities.addAll(activityCollection);
        if (!activityCollection.isEmpty()) {
            this.addModelRoot(BPELUtils.getProcess(activityCollection.iterator().next()));
        }
    }

    protected boolean isAcceptableLinkName(Flow flow, String proposedName) {
        for (Link link : FlowLinkUtil.getFlowLinks(flow)) {
            if (!proposedName.equals(link.getName())) continue;
            return false;
        }
        return true;
    }

    protected void revalidateLink(Link link) {
        Activity target;
        Flow linkFlow = (Flow)link.eContainer().eContainer();
        Activity source = FlowLinkUtil.getLinkSource(link);
        Flow commonFlow = FlowLinkUtil.getCommonFlow(source, target = FlowLinkUtil.getLinkTarget(link));
        if (commonFlow == null) {
            this.deleteLinksCmd.add((Command)new DeleteLinkCommand(link));
        } else if (commonFlow != linkFlow) {
            if (!this.isAcceptableLinkName(commonFlow, link.getName())) {
                String s;
                int i = 0;
                while (!this.isAcceptableLinkName(commonFlow, s = String.valueOf(link.getName()) + "_" + ++i)) {
                }
                link.setName(s);
            }
            FlowLinkUtil.removeFlowLink(linkFlow, link);
            FlowLinkUtil.addFlowLink(commonFlow, link);
        }
    }

    @Override
    public void doExecute() {
        this.deleteLinksCmd = new CompoundCommand();
        HashSet<Object> revalidatingSet = new HashSet<Object>();
        for (Activity activity : this.activities) {
            ModelHelper.addSubtreeToCollection(activity, revalidatingSet);
        }
        for (Object object : revalidatingSet) {
            Targets targets;
            if (!(object instanceof Activity)) continue;
            Activity activity = (Activity)object;
            Sources sources = activity.getSources();
            if (sources != null) {
                Iterator it2 = sources.getChildren().iterator();
                while (it2.hasNext()) {
                    this.revalidateLink(((Source)it2.next()).getLink());
                }
            }
            if ((targets = activity.getTargets()) == null) continue;
            Iterator it2 = targets.getChildren().iterator();
            while (it2.hasNext()) {
                this.revalidateLink(((Target)it2.next()).getLink());
            }
        }
        if (!this.deleteLinksCmd.isEmpty()) {
            this.deleteLinksCmd.execute();
        }
    }
}

