/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;

public class ListAndViewDialog
extends AbstractElementListSelectionDialog {
    private String fUpperListLabel;
    private String fLowerViewLabel;
    private Object[] fElements = new Object[0];
    private Object[] fQualifierElements;
    protected IDialogSettings fSettings;

    public ListAndViewDialog(Shell parent, ILabelProvider elementRenderer) {
        super(parent, elementRenderer);
        this.setSize(75, 15);
        this.setAllowDuplicates(true);
        this.fSettings = BPELUIPlugin.INSTANCE.getDialogSettingsFor((Object)this);
        this.setDialogBoundsSettings(this.fSettings, this.getDialogBoundsStrategy());
    }

    public IDialogSettings getDialogSettings() {
        return this.fSettings;
    }

    public boolean close() {
        this.saveSettings();
        return super.close();
    }

    protected void saveSettings() {
    }

    public void setUpperListLabel(String label) {
        this.fUpperListLabel = label;
    }

    public void setLowerViewLabel(String label) {
        this.fLowerViewLabel = label;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createLabel(contents, this.fUpperListLabel);
        this.createFilteredList(contents);
        this.createLabel(contents, this.fLowerViewLabel);
        this.createLowerView(contents);
        this.setListElements(this.fElements);
        List initialSelections = this.getInitialElementSelections();
        if (!initialSelections.isEmpty()) {
            Object element = initialSelections.get(0);
            this.setSelection(new Object[]{element});
        }
        return contents;
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected Object createLowerView(Composite parent) {
        return null;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    protected void handleSelectionChanged() {
        this.handleUpperSelectionChanged();
        this.updateOkState();
    }

    private void handleUpperSelectionChanged() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.fQualifierElements = this.getFoldedElements(index);
            if (this.fQualifierElements == null) {
                this.updateLowerViewWidget(new Object[0]);
            } else {
                this.updateLowerViewWidget(this.fQualifierElements);
            }
        } else {
            this.updateLowerViewWidget(new Object[0]);
        }
        this.validateCurrentSelection();
        this.updateOkState();
    }

    protected void updateLowerViewWidget(Object[] elements) {
    }
}

