/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.remote.NewArduinoTargetWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ArduinoRemoteServicesUI
extends AbstractRemoteUIConnectionService {
    private final IRemoteConnectionType connectionType;

    public ArduinoRemoteServicesUI(IRemoteConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        try {
            context.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.arduino.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    public IRemoteUIConnectionWizard getConnectionWizard(Shell shell) {
        return new NewArduinoTargetWizard(shell, this.connectionType);
    }

    public ILabelProvider getLabelProvider() {
        return new AbstractRemoteUIConnectionService.DefaultLabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImageRegistry().get("org.eclipse.cdt.arduino.ui.connectionType");
            }
        };
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (IRemoteUIConnectionService.class.equals(service)) {
                return (T)((Object)new ArduinoRemoteServicesUI(connectionType));
            }
            return null;
        }
    }
}

