/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIStackListArgumentsInfo
extends MIInfo {
    MIFrame[] frames = null;

    public MIStackListArgumentsInfo(MIOutput out) {
        super(out);
        MIResultRecord rr;
        ArrayList<MIFrame> aList = new ArrayList<MIFrame>(1);
        if (this.isDone() && (rr = out.getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("stack-args")) {
                    MIValue val = results[i].getMIValue();
                    if (val instanceof MIList) {
                        this.parseStack((MIList)val, aList);
                    } else if (val instanceof MITuple) {
                        this.parseStack((MITuple)val, aList);
                    }
                }
                ++i;
            }
        }
        this.frames = aList.toArray(new MIFrame[aList.size()]);
    }

    public MIFrame[] getMIFrames() {
        return this.frames;
    }

    private void parseStack(MIList miList, List<MIFrame> aList) {
        MIResult[] results = miList.getMIResults();
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                aList.add(new MIFrame((MITuple)value));
            }
            ++i;
        }
    }

    private void parseStack(MITuple miTuple, List<MIFrame> aList) {
        MIResult[] results = miTuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                aList.add(new MIFrame((MITuple)value));
            }
            ++i;
        }
    }
}

