/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.debug.service.IBreakpointAttributeTranslator;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

public class BreakpointsMediator
extends AbstractDsfService
implements IBreakpointManagerListener,
IBreakpointListener {
    private IBreakpointAttributeTranslator fAttributeTranslator;
    IBreakpoints fBreakpoints;
    IBreakpointManager fBreakpointManager;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<Map<String, Object>>>> fPlatformBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<Map<String, Object>>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>>> fBreakpointDMContexts = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>>>();
    private Set<IBreakpoint> fPendingRequests = new HashSet<IBreakpoint>();
    private Set<IBreakpoint> fPendingBreakpoints = new HashSet<IBreakpoint>();

    public BreakpointsMediator(DsfSession session, IBreakpointAttributeTranslator attributeTranslator) {
        super(session);
        this.fAttributeTranslator = attributeTranslator;
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(this.getExecutor(), rm){

            @Override
            protected void handleSuccess() {
                BreakpointsMediator.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fBreakpoints = this.getServicesTracker().getService(IBreakpoints.class);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fAttributeTranslator.initialize(this);
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.register(new String[]{BreakpointsMediator.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.fBreakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fAttributeTranslator.dispose();
        CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getExecutor(), rm){

            @Override
            protected void handleCompleted() {
                BreakpointsMediator.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> platformBPKeysCopy = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fPlatformBPs.size());
        platformBPKeysCopy.addAll(0, this.fPlatformBPs.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : platformBPKeysCopy) {
            this.stopTrackingBreakpoints(dmc, countingRm);
        }
        countingRm.setDoneCount(platformBPKeysCopy.size());
    }

    @Override
    protected BundleContext getBundleContext() {
        return DsfPlugin.getBundleContext();
    }

    public void startTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        final IBreakpoints.IBreakpointsTargetDMContext breakpointsDmc = DMContexts.getAncestorOfType(dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (breakpointsDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Invalid context type", null));
            rm.done();
            return;
        }
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs != null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Context already initialized", null));
            rm.done();
            return;
        }
        this.fPlatformBPs.put(breakpointsDmc, new HashMap());
        this.fBreakpointDMContexts.put(breakpointsDmc, new HashMap());
        new Job("MI Debugger: Install initial breakpoint list."){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                HashMap<IBreakpoint, List<Map<String, Object>>> initialPlatformBPs = new HashMap<IBreakpoint, List<Map<String, Object>>>();
                try {
                    IBreakpoint[] bps;
                    IBreakpoint[] iBreakpointArray = bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint bp = iBreakpointArray[n2];
                        if (BreakpointsMediator.this.fAttributeTranslator.supportsBreakpoint(bp)) {
                            List<Map<String, Object>> attrsArray = BreakpointsMediator.this.fAttributeTranslator.getBreakpointAttributes(bp, BreakpointsMediator.this.fBreakpointManager.isEnabled());
                            initialPlatformBPs.put(bp, attrsArray);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.cdt.dsf", 10004, "Unable to read initial breakpoint attributes", (Throwable)e);
                    rm.setStatus((IStatus)status);
                    rm.done();
                    return status;
                }
                BreakpointsMediator.this.getExecutor().submit(() -> BreakpointsMediator.this.installInitialBreakpoints(breakpointsDmc, initialPlatformBPs, rm));
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void installInitialBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, Map<IBreakpoint, List<Map<String, Object>>> initialPlatformBPs, RequestMonitor rm) {
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getExecutor(), rm);
        countingRm.setDoneCount(initialPlatformBPs.size());
        for (IBreakpoint bp : initialPlatformBPs.keySet()) {
            List<Map<String, Object>> attrs = initialPlatformBPs.get(bp);
            this.installBreakpoint(dmc, bp, attrs, new RequestMonitor(this.getExecutor(), countingRm));
        }
    }

    public void stopTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, RequestMonitor rm) {
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10005, "Breakpoints not installed for given context", null));
            rm.done();
            return;
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final IBreakpoint bp : platformBPs.keySet()) {
            this.uninstallBreakpoint(dmc, bp, new RequestMonitor(this.getExecutor(), countingRm){

                @Override
                protected void handleCompleted() {
                    new Job("Breakpoint status update"){
                        {
                            super($anonymous0);
                            this.setSystem(true);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(bp);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    countingRm.done();
                }
            });
        }
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, final List<Map<String, Object>> attrsList, final RequestMonitor rm) {
        final Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        final Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(dmc);
        assert (breakpointIDs != null);
        if (platformBPs.containsKey(breakpoint)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10001, "Breakpoint already installed", null));
            rm.done();
            return;
        }
        final CountingRequestMonitor installRM = new CountingRequestMonitor(this.getExecutor(), rm){

            @Override
            protected void handleCompleted() {
                platformBPs.put(breakpoint, attrsList);
                new Job("Breakpoint status update"){
                    {
                        super($anonymous0);
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                rm.done();
            }
        };
        installRM.setDoneCount(attrsList.size());
        for (Map<String, Object> attrs : attrsList) {
            this.fBreakpoints.insertBreakpoint(dmc, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                @Override
                protected void handleCompleted() {
                    LinkedList<IBreakpoints.IBreakpointDMContext> list = (LinkedList<IBreakpoints.IBreakpointDMContext>)breakpointIDs.get(breakpoint);
                    if (list == null) {
                        list = new LinkedList<IBreakpoints.IBreakpointDMContext>();
                        breakpointIDs.put(breakpoint, list);
                    }
                    if (this.isSuccess()) {
                        list.add((IBreakpoints.IBreakpointDMContext)this.getData());
                    }
                    installRM.done();
                }
            });
        }
    }

    private void uninstallBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, final RequestMonitor rm) {
        CountingRequestMonitor removeRM = new CountingRequestMonitor(this.getExecutor(), rm){

            @Override
            protected void handleCompleted() {
                Map platformBPs = (Map)BreakpointsMediator.this.fPlatformBPs.get(dmc);
                if (platformBPs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid context", null));
                    rm.done();
                    return;
                }
                platformBPs.remove(breakpoint);
                Map breakpointIDs = (Map)BreakpointsMediator.this.fBreakpointDMContexts.get(dmc);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid breakpoint", null));
                    rm.done();
                    return;
                }
                ((List)breakpointIDs.get(breakpoint)).clear();
                breakpointIDs.remove(breakpoint);
                new Job("Breakpoint status update"){
                    {
                        super($anonymous0);
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                rm.done();
            }
        };
        Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(dmc);
        if (breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        List<IBreakpoints.IBreakpointDMContext> list = breakpointIDs.get(breakpoint);
        int count = 0;
        if (list != null) {
            for (IBreakpoints.IBreakpointDMContext bp : list) {
                this.fBreakpoints.removeBreakpoint(bp, removeRM);
            }
            count = list.size();
        }
        removeRM.setDoneCount(count);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final IBreakpoint breakpoint, List<Map<String, Object>> newAttrsList0, IMarkerDelta oldValues, RequestMonitor rm) {
        final Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(context);
        final Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(context);
        if (platformBPs == null || breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        List<Map<String, Object>> oldAttrsList0 = platformBPs.get(breakpoint);
        if (oldAttrsList0 == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        ArrayList oldBpContexts = new ArrayList(breakpointIDs.get(breakpoint));
        final List<Map<String, Object>> commonAttrsList = this.getCommonAttributeMaps(newAttrsList0, oldAttrsList0);
        final ArrayList<IBreakpoints.IBreakpointDMContext> newBpContexts = new ArrayList<IBreakpoints.IBreakpointDMContext>(commonAttrsList.size());
        final ArrayList<Map<String, Object>> newAttrsList = new ArrayList<Map<String, Object>>(newAttrsList0);
        newAttrsList.removeAll(commonAttrsList);
        ArrayList<Map<String, Object>> oldAttrsList = new ArrayList<Map<String, Object>>(oldAttrsList0);
        int i = 0;
        while (i < oldAttrsList.size()) {
            if (commonAttrsList.contains(oldAttrsList.get(i)) && oldBpContexts.size() > i) {
                newBpContexts.add((IBreakpoints.IBreakpointDMContext)oldBpContexts.remove(i));
            }
            ++i;
        }
        oldAttrsList.removeAll(commonAttrsList);
        List<Map<String, Object>> attrDeltasList = this.getAttributesDeltas(oldAttrsList, newAttrsList);
        final CountingRequestMonitor countingRM = new CountingRequestMonitor(this.getExecutor(), rm){

            @Override
            protected void handleCompleted() {
                breakpointIDs.put(breakpoint, newBpContexts);
                newAttrsList.addAll(commonAttrsList);
                platformBPs.put(breakpoint, newAttrsList);
                new Job("Breakpoint status update"){
                    {
                        super($anonymous0);
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                super.handleCompleted();
            }
        };
        countingRM.setDoneCount(attrDeltasList.size());
        int i2 = 0;
        while (i2 < attrDeltasList.size()) {
            Map attrs;
            if (attrDeltasList.get(i2) == null) {
                this.fBreakpoints.removeBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i2), countingRM);
            } else if (i2 >= oldBpContexts.size()) {
                attrs = (Map)newAttrsList.get(i2);
                this.fBreakpoints.insertBreakpoint(context, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)countingRM){

                    @Override
                    protected void handleSuccess() {
                        newBpContexts.add((IBreakpoints.IBreakpointDMContext)this.getData());
                        countingRM.done();
                    }
                });
            } else if (!this.fAttributeTranslator.canUpdateAttributes((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i2), attrDeltasList.get(i2))) {
                attrs = (Map)newAttrsList.get(i2);
                this.fBreakpoints.removeBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i2), new RequestMonitor(this.getExecutor(), countingRM){

                    @Override
                    protected void handleCompleted() {
                        BreakpointsMediator.this.fBreakpoints.insertBreakpoint(context, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)BreakpointsMediator.this.getExecutor(), (RequestMonitor)countingRM){

                            @Override
                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    newBpContexts.add((IBreakpoints.IBreakpointDMContext)this.getData());
                                }
                                countingRM.done();
                            }
                        });
                    }
                });
            } else {
                final IBreakpoints.IBreakpointDMContext bpCtx = (IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i2);
                this.fBreakpoints.updateBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i2), (Map)newAttrsList.get(i2), new RequestMonitor(this.getExecutor(), countingRM){

                    @Override
                    protected void handleSuccess() {
                        newBpContexts.add(bpCtx);
                        countingRM.done();
                    }
                });
            }
            ++i2;
        }
    }

    private List<Map<String, Object>> getCommonAttributeMaps(List<Map<String, Object>> array1, List<Map<String, Object>> array2) {
        LinkedList<Map<String, Object>> intersection = new LinkedList<Map<String, Object>>();
        ArrayList<Map<String, Object>> list2 = new ArrayList<Map<String, Object>>(array2);
        for (Map<String, Object> array1Map : array1) {
            if (!list2.remove(array1Map)) continue;
            intersection.add(array1Map);
        }
        return intersection;
    }

    private List<Map<String, Object>> getAttributesDeltas(List<Map<String, Object>> oldAttributesList, List<Map<String, Object>> newAttributesList) {
        ArrayList<Map<String, Object>> deltas = new ArrayList<Map<String, Object>>(oldAttributesList.size());
        int i = 0;
        while (i < oldAttributesList.size() && i < newAttributesList.size()) {
            Map<String, Object> oldAttributes = oldAttributesList.get(i);
            Map<String, Object> newAttributes = newAttributesList.get(i);
            HashMap<String, Object> delta = new HashMap<String, Object>();
            Set<String> oldKeySet = oldAttributes.keySet();
            Set<String> newKeySet = newAttributes.keySet();
            HashSet<String> commonKeys = new HashSet<String>(newKeySet);
            commonKeys.retainAll(oldKeySet);
            HashSet<String> addedKeys = new HashSet<String>(newKeySet);
            addedKeys.removeAll(oldKeySet);
            HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
            removedKeys.removeAll(newKeySet);
            for (String key : commonKeys) {
                if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
                delta.put(key, newAttributes.get(key));
            }
            for (String key : addedKeys) {
                delta.put(key, newAttributes.get(key));
            }
            for (String key : removedKeys) {
                delta.put(key, null);
            }
            deltas.add(delta);
            ++i;
        }
        i = deltas.size();
        while (i < newAttributesList.size()) {
            deltas.add(newAttributesList.get(i));
            ++i;
        }
        i = deltas.size();
        while (i < oldAttributesList.size()) {
            deltas.add(null);
            ++i;
        }
        return deltas;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] iBreakpointArray = this.fBreakpointManager.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            this.breakpointChanged(breakpoint, null);
            ++n2;
        }
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                final List<Map<String, Object>> attrsArray = this.fAttributeTranslator.getBreakpointAttributes(breakpoint, this.fBreakpointManager.isEnabled());
                this.getExecutor().execute(new DsfRunnable(){

                    @Override
                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor(BreakpointsMediator.this.getExecutor(), null){

                            @Override
                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            BreakpointsMediator.this.installBreakpoint(dmc, breakpoint, attrsArray, new RequestMonitor(BreakpointsMediator.this.getExecutor(), countingRm));
                        }
                    }
                });
            }
            catch (CoreException e) {
                DsfPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointChanged(final IBreakpoint breakpoint, final IMarkerDelta delta) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                final List<Map<String, Object>> attrsArray = this.fAttributeTranslator.getBreakpointAttributes(breakpoint, this.fBreakpointManager.isEnabled());
                this.getExecutor().execute(new DsfRunnable(){

                    @Override
                    public void run() {
                        if (BreakpointsMediator.this.fPendingRequests.contains(breakpoint)) {
                            BreakpointsMediator.this.fPendingBreakpoints.add(breakpoint);
                            return;
                        }
                        CountingRequestMonitor countingRm = new CountingRequestMonitor(BreakpointsMediator.this.getExecutor(), null){

                            @Override
                            protected void handleCompleted() {
                                if (!this.isSuccess() && this.getStatus().getSeverity() == 4) {
                                    DsfPlugin.getDefault().getLog().log(this.getStatus());
                                }
                                BreakpointsMediator.this.fPendingRequests.remove(breakpoint);
                                if (BreakpointsMediator.this.fPendingBreakpoints.contains(breakpoint)) {
                                    BreakpointsMediator.this.fPendingBreakpoints.remove(breakpoint);
                                    new Job("Deferred breakpoint changed job"){
                                        {
                                            super($anonymous0);
                                            this.setSystem(true);
                                        }

                                        protected IStatus run(IProgressMonitor monitor) {
                                            BreakpointsMediator.this.breakpointChanged(breakpoint, delta);
                                            return Status.OK_STATUS;
                                        }
                                    }.schedule();
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        BreakpointsMediator.this.fPendingRequests.add(breakpoint);
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            BreakpointsMediator.this.modifyBreakpoint(dmc, breakpoint, attrsArray, delta, new RequestMonitor(BreakpointsMediator.this.getExecutor(), countingRm));
                        }
                    }
                });
            }
            catch (CoreException e) {
                DsfPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                this.getExecutor().execute(new DsfRunnable(){

                    @Override
                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor(BreakpointsMediator.this.getExecutor(), null){

                            @Override
                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            if (((Map)BreakpointsMediator.this.fPlatformBPs.get(dmc)).remove(breakpoint) == null) continue;
                            BreakpointsMediator.this.uninstallBreakpoint(dmc, breakpoint, countingRm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

