/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.ModulesOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class UpdateModuleOperation
extends ModulesOperation {
    public UpdateModuleOperation(CloudFoundryServerBehaviour behaviour, IModule module) {
        super(behaviour, module);
    }

    @Override
    public String getOperationName() {
        CloudFoundryApplicationModule appModule = this.getCloudModule(this.getFirstModule());
        String name = appModule != null ? appModule.getDeployedApplicationName() : this.getFirstModule().getName();
        return NLS.bind((String)Messages.UpdateModuleOperation_OPERATION_MESSAGE, (Object)name);
    }

    @Override
    public void runOnVerifiedModule(IProgressMonitor monitor) throws CoreException {
        if (this.shouldUpdateInServer()) {
            this.updateModule(monitor);
        }
        ServerEventHandler.getDefault().fireModuleUpdated(this.getBehaviour().getCloudFoundryServer(), this.getFirstModule());
    }

    protected CloudFoundryApplicationModule updateModule(IProgressMonitor monitor) throws CoreException {
        return this.getBehaviour().updateModuleWithAllCloudInfo(this.getFirstModule(), monitor);
    }

    protected boolean shouldUpdateInServer() {
        try {
            if (this.getBehaviour().getCloudFoundryServer().getServer() instanceof Server) {
                Server server = (Server)this.getBehaviour().getCloudFoundryServer().getServer();
                return 1 != server.getModuleState(new IModule[]{this.getFirstModule()});
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        return true;
    }
}

