/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrimaryKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.impl.CheckConstraintImpl;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogCheckConstraint
extends CheckConstraintImpl
implements ICatalogObject {
    private boolean loaded = false;
    private boolean dependencyLoaded = false;

    public void refresh() {
        this.loaded = false;
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public SearchCondition getSearchCondition() {
        if (!this.loaded) {
            this.load();
        }
        return this.searchCondition;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getSearchCondition();
        } else if (id == 2) {
            this.getDependencies();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogPrimaryKey.loadDependencies(this.getConnection(), super.getDependencies(), (Constraint)this);
            this.loadDependencies(super.getDependencies());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT TEXT FROM SYSCAT.CHECKS" + this.getWhereClause());
            while (r.next()) {
                String text = r.getString(1);
                if (text != null) {
                    text = text.replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
                }
                DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
                SearchCondition searchCondition = (SearchCondition)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
                searchCondition.setSQL(text);
                this.setSearchCondition(searchCondition);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private void loadDependencies(EList dependencyList) throws SQLException {
        Table table = (Table)this.eContainer();
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = this.getConnection().createStatement();
        ResultSet r = s.executeQuery("SELECT COLNAME FROM SYSCAT.COLCHECKS WHERE CONSTNAME='" + LUWUtil.getIdentifier(this.getName()) + "' AND TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'");
        try {
            while (r.next()) {
                String colName = r.getString(1);
                Column column = this.getColumn(colName);
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)column);
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private String getWhereClause() {
        this.getBaseTable();
        return " WHERE CONSTNAME='" + LUWUtil.getIdentifier(this.getName()) + "' AND TABSCHEMA='" + LUWUtil.getIdentifier(this.getBaseTable().getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(this.getBaseTable().getName()) + "'";
    }

    private Column getColumn(String columnName) {
        Column c;
        BaseTable table = this.getBaseTable();
        if (table instanceof LUWCatalogTable && (c = ((LUWCatalogTable)table).getColumn(columnName)) != null) {
            return c;
        }
        for (Column c2 : table.getColumns()) {
            if (!c2.getName().equals(columnName)) continue;
            return c2;
        }
        LUWCatalogColumn column = new LUWCatalogColumn();
        column.setName(columnName);
        column.setTable((Table)table);
        return column;
    }
}

