/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class BlockStaticScope
extends StaticScope {
    private static final long serialVersionUID = -3882063260379968149L;

    public BlockStaticScope(StaticScope parentScope) {
        super(parentScope);
    }

    @Override
    public StaticScope getLocalScope() {
        return this.getEnclosingScope().getLocalScope();
    }

    @Override
    public int isDefined(String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return depth << 16 | this.exists(name);
        }
        return this.getEnclosingScope().isDefined(name, depth + 1);
    }

    @Override
    public String[] getAllNamesInScope() {
        String[] variables = this.getEnclosingScope().getAllNamesInScope();
        String[] ourVariables = this.getVariables();
        if (ourVariables == null) {
            return variables;
        }
        int newSize = variables.length + ourVariables.length;
        String[] names = new String[newSize];
        System.arraycopy(variables, 0, names, 0, variables.length);
        System.arraycopy(ourVariables, 0, names, variables.length, ourVariables.length);
        return names;
    }

    @Override
    protected AssignableNode assign(ISourcePosition position, String name, Node value, StaticScope topScope, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return new DAsgnNode(position, name, depth << 16 | slot, value);
        }
        return this.getEnclosingScope().assign(position, name, value, topScope, depth + 1);
    }

    public AssignableNode addAssign(ISourcePosition position, String name, Node value) {
        int slot = this.addVariable(name);
        return new DAsgnNode(position, name, slot, value);
    }

    @Override
    public Node declare(ISourcePosition position, String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return new DVarNode(position, depth << 16 | slot, name);
        }
        return this.getEnclosingScope().declare(position, name, depth + 1);
    }
}

