/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.internal.presence.PresencePlugin;
import org.eclipse.ecf.presence.search.IResult;
import org.eclipse.ecf.presence.search.IResultList;

public class ResultList
implements IResultList {
    protected Set results = Collections.synchronizedSet(new HashSet());

    public ResultList(Collection existingResults) {
        if (existingResults != null) {
            this.addAll(existingResults);
        }
    }

    public ResultList() {
    }

    public boolean add(IResult item) {
        if (item == null) {
            return false;
        }
        return this.results.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection existingResults) {
        if (existingResults == null) {
            return;
        }
        Set set = this.results;
        synchronized (set) {
            Iterator i = existingResults.iterator();
            while (i.hasNext()) {
                this.add((IResult)i.next());
            }
        }
    }

    public Collection getResults() {
        return this.results;
    }

    public boolean remove(IResult item) {
        return this.results.remove(item);
    }

    public IResult getResult(String field, String value) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = PresencePlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ResultList[");
        sb.append("results=").append(this.getResults()).append("]");
        return sb.toString();
    }
}

