/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractFeatureMapTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.FieldInfo;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.util.ImplementationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class NonAuditFeatureMapTableMapping
extends AbstractFeatureMapTableMapping
implements IListMappingDeltaSupport {
    private static final int TEMP_INDEX = -1;
    private static final int UNBOUNDED_MOVE = -1;
    private String sqlClear;
    private String sqlUpdateIndex;
    private String sqlUpdateValue;
    private String sqlDeleteItem;
    private String sqlMoveDownWithLimit;
    private String sqlMoveDown;
    private String sqlMoveUpWithLimit;
    private String sqlMoveUp;

    public NonAuditFeatureMapTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? ");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append("CDO_IDX");
        builder.append("=? ");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("CDO_IDX");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=? ");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("CDO_FEATURE");
        builder.append("=?,");
        Iterator<String> iter = this.getColumnNames().iterator();
        while (iter.hasNext()) {
            String column = iter.next();
            builder.append(column);
            builder.append("=?");
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=? ");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("CDO_IDX");
        builder.append("=");
        builder.append("CDO_IDX");
        builder.append("-1 WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append(">? ");
        this.sqlMoveDown = builder.toString();
        builder.append(" AND ");
        builder.append("CDO_IDX");
        builder.append("<=?");
        this.sqlMoveDownWithLimit = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("CDO_IDX");
        builder.append("=");
        builder.append("CDO_IDX");
        builder.append("+1 WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append(">=? ");
        this.sqlMoveUp = builder.toString();
        builder.append(" AND ");
        builder.append("CDO_IDX");
        builder.append("<?");
        this.sqlMoveUpWithLimit = builder.toString();
    }

    @Override
    protected void addKeyFields(List<FieldInfo> list) {
    }

    @Override
    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        this.getMappingStrategy().getStore().getIDHandler().setCDOID(stmt, 1, revision.getID());
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlClear, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        this.clearList(accessor, id);
    }

    public void insertListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        this.move1up(accessor, id, index, -1);
        this.insertValue(accessor, id, index, value, timestamp);
    }

    private void insertValue(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, timestamp);
        ITypeMapping typeMapping = this.getTypeMapping(tag);
        String columnName = this.getColumnName(tag);
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                int column = this.getKeyFields().length + 1;
                int i = 0;
                while (i < this.getColumnNames().size()) {
                    if (this.getColumnNames().get(i).equals(columnName)) {
                        typeMapping.setValue((PreparedStatement)stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                stmt.setInt(column++, index);
                idHandler.setCDOID((PreparedStatement)stmt, column++, tag);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void moveListItem(IDBStoreAccessor accessor, CDOID id, int oldPosition, int newPosition) {
        if (oldPosition == newPosition) {
            return;
        }
        this.updateOneIndex(accessor, id, oldPosition, -1);
        if (oldPosition < newPosition) {
            this.move1down(accessor, id, oldPosition, newPosition);
        } else {
            this.move1up(accessor, id, newPosition, oldPosition);
        }
        this.updateOneIndex(accessor, id, -1, newPosition);
    }

    private void updateOneIndex(IDBStoreAccessor accessor, CDOID id, int oldIndex, int newIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setInt(1, newIndex);
                idHandler.setCDOID((PreparedStatement)stmt, 2, id);
                stmt.setInt(3, oldIndex);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void removeListItem(IDBStoreAccessor accessor, CDOID id, int index) {
        this.deleteItem(accessor, id, index);
        this.move1down(accessor, id, index, -1);
    }

    private void move1down(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(upperIndex == -1 ? this.sqlMoveDown : this.sqlMoveDownWithLimit, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void move1up(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(upperIndex == -1 ? this.sqlMoveUp : this.sqlMoveUpWithLimit, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void deleteItem(IDBStoreAccessor accessor, CDOID id, int index) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDeleteItem, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, index);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void setListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value, long timestamp) {
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, timestamp);
        ITypeMapping mapping = this.getTypeMapping(tag);
        String columnName = this.getColumnName(tag);
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlUpdateValue, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, tag);
                int column = 2;
                int i = 0;
                while (i < this.getColumnNames().size()) {
                    if (this.getColumnNames().get(i).equals(columnName)) {
                        mapping.setValue((PreparedStatement)stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, index);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void processDelta(final IDBStoreAccessor accessor, final CDOID id, int branchId, int oldVersion, int newVersion, final long created, CDOListFeatureDelta listDelta) {
        CDOFeatureDeltaVisitor visitor = new CDOFeatureDeltaVisitor(){

            public void visit(CDOMoveFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.moveListItem(accessor, id, delta.getOldPosition(), delta.getNewPosition());
            }

            public void visit(CDOAddFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.insertListItem(accessor, id, delta.getIndex(), delta.getValue(), created);
            }

            public void visit(CDORemoveFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.removeListItem(accessor, id, delta.getIndex());
            }

            public void visit(CDOSetFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.setListItem(accessor, id, delta.getIndex(), delta.getValue(), created);
            }

            public void visit(CDOUnsetFeatureDelta delta) {
                if (delta.getFeature().isUnsettable()) {
                    throw new ImplementationError("Should not be called");
                }
                NonAuditFeatureMapTableMapping.this.clearList(accessor, id);
            }

            public void visit(CDOListFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }

            public void visit(CDOClearFeatureDelta delta) {
                NonAuditFeatureMapTableMapping.this.clearList(accessor, id);
            }

            public void visit(CDOContainerFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }
        };
        for (CDOFeatureDelta delta : listDelta.getListChanges()) {
            delta.accept(visitor);
        }
    }
}

