/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.DelegatingObjectTypeMapper;

public class ObjectTypeCache
extends DelegatingObjectTypeMapper {
    public static final int DEFAULT_CACHE_CAPACITY = 100000;
    private Map<CDOID, CDOID> memoryCache;
    private int cacheSize;

    public ObjectTypeCache(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    protected CDOID doGetObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.memoryCache.get(id);
    }

    protected boolean doPutObjectType(IDBStoreAccessor accessor, CDOID id, CDOID type) {
        return this.memoryCache.put(id, type) == null;
    }

    protected boolean doRemoveObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.memoryCache.remove(id) != null;
    }

    protected CDOID doGetMaxID(Connection connection, IIDHandler idHandler) {
        return null;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.memoryCache = Collections.synchronizedMap(new MemoryCache(this.cacheSize));
    }

    protected void doDeactivate() throws Exception {
        this.memoryCache = null;
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MemoryCache
    extends LinkedHashMap<CDOID, CDOID> {
        private static final long serialVersionUID = 1L;
        private int capacity;

        public MemoryCache(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<CDOID, CDOID> eldest) {
            return this.size() > this.capacity;
        }
    }
}

