/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteResourceAction
extends SafeAction {
    private final Shell shell;
    private final Set<CDOResourceNode> nodes;

    public DeleteResourceAction(Shell shell, List<CDOResourceNode> nodes) {
        super(Messages.getString("DeleteResourceAction_1"), Messages.getString("DeleteResourceAction_5"), SharedIcons.getDescriptor((String)"etool16/delete"));
        this.shell = shell;
        this.nodes = new HashSet<CDOResourceNode>(nodes);
    }

    protected void safeRun() throws Exception {
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString("DeleteResourceAction_1"), (String)MessageFormat.format(Messages.getString("DeleteResourceAction_2"), this.nodes.size()))) {
            Job job = new Job(Messages.getString("DeleteResourceAction_3")){

                protected IStatus run(IProgressMonitor monitor) {
                    HashSet<CDOResourceNode> nestedNodes = new HashSet<CDOResourceNode>();
                    for (CDOResourceNode node : DeleteResourceAction.this.nodes) {
                        if (!this.isNested(node)) continue;
                        nestedNodes.add(node);
                    }
                    DeleteResourceAction.this.nodes.removeAll(nestedNodes);
                    HashMap<Integer, CDOTransaction> repositoryToTransaction = new HashMap<Integer, CDOTransaction>();
                    for (CDOResourceNode node : DeleteResourceAction.this.nodes) {
                        CDOObject writableNode;
                        EObject container;
                        CDOSession session = node.cdoView().getSession();
                        int sessionID = session.getSessionID();
                        CDOTransaction transaction = (CDOTransaction)repositoryToTransaction.get(sessionID);
                        if (transaction == null) {
                            transaction = OpenTransactionAction.openTransaction(session);
                            repositoryToTransaction.put(sessionID, transaction);
                        }
                        if ((container = (writableNode = transaction.getObject(node.cdoID())).eContainer()) == null) {
                            container = (CDOResource)writableNode.eResource();
                        }
                        if (container instanceof CDOResource) {
                            ((CDOResource)container).getContents().remove((Object)writableNode);
                            continue;
                        }
                        if (!(container instanceof CDOResourceFolder)) continue;
                        ((CDOResourceFolder)container).getNodes().remove((Object)writableNode);
                    }
                    for (CDOTransaction transaction : repositoryToTransaction.values()) {
                        try {
                            try {
                                transaction.commit();
                            }
                            catch (Exception ex) {
                                OM.LOG.error(MessageFormat.format(Messages.getString("DeleteResourceAction_4"), ((Object)((Object)this)).getClass().getName().toString()), (Throwable)ex);
                                transaction.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            transaction.close();
                            throw throwable;
                        }
                        transaction.close();
                    }
                    return Status.OK_STATUS;
                }

                private boolean isNested(CDOResourceNode node) {
                    CDOResourceFolder folder = node.getFolder();
                    if (folder != null) {
                        if (DeleteResourceAction.this.nodes.contains(folder)) {
                            return true;
                        }
                        return this.isNested((CDOResourceNode)folder);
                    }
                    return false;
                }
            };
            job.schedule();
        }
    }
}

