/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.emf.mwe.ui.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewWorkflowFileWizard
extends BasicNewResourceWizard {
    private Page mainPage;
    private final String extension = Messages.NewWorkflowFileWizard_Extension;
    String initialContents = "";

    public void addPages() {
        super.addPages();
        this.mainPage = new Page(this.getSelection());
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.NewWorkflowFileWizard_DialogTitle);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean canFinish() {
        return this.mainPage.getFileName().endsWith("." + this.extension);
    }

    public boolean performFinish() {
        final IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.logError((Exception)((Object)e));
                }
            }
        });
        return true;
    }

    class Page
    extends WizardNewFileCreationPage {
        public Page(IStructuredSelection selection) {
            super("newFilePage1", selection);
            this.setFileName(String.valueOf(Messages.NewWorkflowFileWizard_DefaultFileName) + NewWorkflowFileWizard.this.extension);
            this.setTitle(Messages.NewWorkflowFileWizard_WindowTitle);
            this.setDescription(Messages.NewWorkflowFileWizard_WindowDescription);
        }

        public String getErrorMessage() {
            if (!this.getFileName().endsWith("." + NewWorkflowFileWizard.this.extension)) {
                return String.valueOf(Messages.NewWorkflowFileWizard_WrongExtension) + NewWorkflowFileWizard.this.extension;
            }
            return null;
        }

        protected InputStream getInitialContents() {
            return new ByteArrayInputStream(NewWorkflowFileWizard.this.initialContents.getBytes());
        }
    }
}

