/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.handlers;

import java.util.concurrent.TimeUnit;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ResetSendMode;
import org.eclipse.epp.logging.aeri.core.SendMode;

public class SetSendModeHandler {
    @Execute
    public void execute(SendMode mode, ResetSendMode when, ISystemSettings system) {
        system.setSendMode(mode);
        system.setResetSendMode(when);
        switch (when) {
            case HOURS_24: {
                system.setResetSendModeOn(SetSendModeHandler.in24Hours());
            }
            case RESTART: 
            case PERMANENT: 
            case KEEP: {
                system.setResetSendModeOn(0L);
            }
        }
    }

    private static long in24Hours() {
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
    }
}

