/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import static com.google.common.collect.ImmutableSet.of;
import static org.eclipse.epp.internal.logging.aeri.ide.IIdePackage.Literals.*;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.EmfPreferences.listen;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.IDEConstants.BUNDLE_ID;
import static org.eclipse.epp.logging.aeri.core.IModelPackage.Literals.*;

import java.util.List;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;

import com.google.common.collect.ImmutableSet;

public class SettingsPersistingRegistryServersCreationFunction extends ExtensionPointServersCreationFunction {

    ImmutableSet<EAttribute> listenableAttributes = of(USER_SETTINGS__REPORTER_EMAIL, USER_SETTINGS__REPORTER_NAME,
            USER_SETTINGS__ANONYMIZE_STACK_TRACES, SERVER_DESCRIPTOR__CONFIGURED, SERVER_DESCRIPTOR__ENABLED);

    @Override
    public Object compute(IEclipseContext notused, String contextKey) {
        List<IServerDescriptor> servers = (List<IServerDescriptor>) super.compute(notused, contextKey);
        for (final IServerDescriptor server : servers) {
            String nodeQualifier = BUNDLE_ID + "/servers/" + server.getId(); //$NON-NLS-1$
            listen(nodeQualifier, server, listenableAttributes);
        }
        return servers;
    }
}
