/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.EquinoxObjectClassDefinition;
import org.eclipse.equinox.metatype.impl.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.eclipse.equinox.metatype.impl.FragmentUtils;
import org.eclipse.equinox.metatype.impl.Icon;
import org.eclipse.equinox.metatype.impl.LocalizationElement;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.Persistence;
import org.osgi.framework.Bundle;

public class ObjectClassDefinitionImpl
extends LocalizationElement
implements EquinoxObjectClassDefinition,
Cloneable {
    private static final Comparator<Icon> iconComparator = new Comparator<Icon>(){

        @Override
        public int compare(Icon icon1, Icon icon2) {
            return icon1.getIconSize().compareTo(icon2.getIconSize());
        }
    };
    private final String _name;
    private final String _id;
    private final String _description;
    private final int _type;
    private final List<AttributeDefinitionImpl> _required = new ArrayList<AttributeDefinitionImpl>(7);
    private final List<AttributeDefinitionImpl> _optional = new ArrayList<AttributeDefinitionImpl>(7);
    private final ExtendableHelper helper;
    private volatile List<Icon> icons = null;

    public ObjectClassDefinitionImpl(String name, String description, String id, String localization, Map<String, Map<String, String>> extensionAttributes) {
        this(name, description, id, 0, localization, new ExtendableHelper(extensionAttributes));
    }

    public ObjectClassDefinitionImpl(String name, String description, String id, int type, String localization, ExtendableHelper helper) {
        super(localization);
        this._name = name;
        this._id = id;
        this._description = description;
        this._type = type;
        this.helper = helper;
    }

    public Object clone() {
        ObjectClassDefinitionImpl ocd = new ObjectClassDefinitionImpl(this._name, this._description, this._id, this._type, this.getLocalization(), this.helper);
        for (AttributeDefinitionImpl ad : this._required) {
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), true);
        }
        for (AttributeDefinitionImpl ad : this._optional) {
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), false);
        }
        if (this.icons != null) {
            ocd.setIcons(new ArrayList<Icon>(this.icons));
        }
        return ocd;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    public String getID() {
        return this._id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    @Override
    public EquinoxAttributeDefinition[] getAttributeDefinitions(int filter) {
        switch (filter) {
            case 1: {
                EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._required.size()];
                this._required.toArray(atts);
                return atts;
            }
            case 2: {
                EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._optional.size()];
                this._optional.toArray(atts);
                return atts;
            }
        }
        EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._required.size() + this._optional.size()];
        int i = 0;
        for (AttributeDefinitionImpl attr : this._required) {
            atts[i] = attr;
            ++i;
        }
        for (AttributeDefinitionImpl attr : this._optional) {
            atts[i] = attr;
            ++i;
        }
        return atts;
    }

    void addAttributeDefinition(AttributeDefinitionImpl ad, boolean isRequired) {
        if (isRequired) {
            this._required.add(ad);
        } else {
            this._optional.add(ad);
        }
    }

    public InputStream getIcon(int sizeHint) throws IOException {
        Icon icon = new Icon(null, sizeHint, null);
        List<Icon> icons = this.icons;
        if (icons == null) {
            return null;
        }
        int index = Collections.binarySearch(icons, icon, iconComparator);
        if (index < 0) {
            int average;
            Icon greaterThan;
            int insertionPoint = -(index + 1);
            Icon lessThan = insertionPoint == 0 ? null : icons.get(insertionPoint - 1);
            Icon icon2 = greaterThan = insertionPoint == icons.size() ? null : icons.get(insertionPoint);
            icon = lessThan == null ? greaterThan : (greaterThan == null ? lessThan : (sizeHint < (average = (greaterThan.getIconSize() + lessThan.getIconSize()) / 2) ? lessThan : greaterThan));
        } else {
            icon = icons.get(index);
        }
        Bundle b = icon.getIconBundle();
        URL[] urls = FragmentUtils.findEntries(b, this.getLocalized(icon.getIconName()));
        if (urls != null && urls.length > 0) {
            return urls[0].openStream();
        }
        return null;
    }

    void setIcons(List<Icon> icons) {
        if (icons == null || icons.isEmpty()) {
            return;
        }
        Collections.sort(icons, iconComparator);
        this.icons = Collections.unmodifiableList(icons);
    }

    void setResourceBundle(String assignedLocale, Bundle bundle) {
        this.setLocaleAndBundle(assignedLocale, bundle);
        for (AttributeDefinitionImpl ad : this._required) {
            ad.setLocaleAndBundle(assignedLocale, bundle);
        }
        for (AttributeDefinitionImpl ad : this._optional) {
            ad.setLocaleAndBundle(assignedLocale, bundle);
        }
    }

    @Override
    public Map<String, String> getExtensionAttributes(String schema) {
        return this.helper.getExtensionAttributes(schema);
    }

    @Override
    public Set<String> getExtensionUris() {
        return this.helper.getExtensionUris();
    }

    void getStrings(Set<String> strings) {
        this.helper.getStrings(strings);
        strings.add(this._description);
        strings.add(this._id);
        strings.add(this._name);
        strings.add(this.getLocalization());
        List<Icon> icons = this.icons;
        if (icons != null) {
            for (Icon icon : icons) {
                icon.getStrings(strings);
            }
        }
    }

    static ObjectClassDefinitionImpl load(Bundle b, LogTracker logger, Persistence.Reader reader) throws IOException {
        String description = reader.readString();
        String id = reader.readString();
        String name = reader.readString();
        int type = reader.readInt();
        String localization = reader.readString();
        ExtendableHelper helper = ExtendableHelper.load(reader);
        ObjectClassDefinitionImpl result = new ObjectClassDefinitionImpl(name, description, id, type, localization, helper);
        int numIcons = reader.readInt();
        ArrayList<Icon> icons = null;
        if (numIcons > 0) {
            icons = new ArrayList<Icon>(numIcons);
            int i = 0;
            while (i < numIcons) {
                icons.add(Icon.load(reader, b));
                ++i;
            }
        }
        result.setIcons(icons);
        int numRequired = reader.readInt();
        int i = 0;
        while (i < numRequired) {
            result.addAttributeDefinition(AttributeDefinitionImpl.load(reader, logger), true);
            ++i;
        }
        int numOptional = reader.readInt();
        int i2 = 0;
        while (i2 < numOptional) {
            result.addAttributeDefinition(AttributeDefinitionImpl.load(reader, logger), false);
            ++i2;
        }
        return result;
    }

    void write(Persistence.Writer writer) throws IOException {
        writer.writeString(this._description);
        writer.writeString(this._id);
        writer.writeString(this._name);
        writer.writeInt(this._type);
        writer.writeString(this.getLocalization());
        this.helper.write(writer);
        List<Icon> curIcons = this.icons;
        writer.writeInt(curIcons == null ? 0 : curIcons.size());
        if (curIcons != null) {
            for (Icon icon : curIcons) {
                icon.write(writer);
            }
        }
        writer.writeInt(this._required.size());
        for (AttributeDefinitionImpl ad : this._required) {
            ad.write(writer);
        }
        writer.writeInt(this._optional.size());
        for (AttributeDefinitionImpl ad : this._optional) {
            ad.write(writer);
        }
    }
}

