/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.DequeQueue;
import org.eclipse.jpt.common.utility.internal.queue.EmptyQueue;
import org.eclipse.jpt.common.utility.internal.queue.FixedCapacityArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.queue.ListQueue;
import org.eclipse.jpt.common.utility.internal.queue.PriorityQueue;
import org.eclipse.jpt.common.utility.internal.queue.StackQueue;
import org.eclipse.jpt.common.utility.internal.queue.SynchronizedQueue;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class QueueTools {
    public static <E> boolean enqueueAll(Queue<? super E> queue, Iterable<? extends E> iterable) {
        return QueueTools.enqueueAll(queue, iterable.iterator());
    }

    public static <E> boolean enqueueAll(Queue<? super E> queue, Iterator<? extends E> iterator) {
        return iterator.hasNext() && QueueTools.enqueueAll_(queue, iterator);
    }

    private static <E> boolean enqueueAll_(Queue<? super E> queue, Iterator<? extends E> iterator) {
        do {
            queue.enqueue(iterator.next());
        } while (iterator.hasNext());
        return true;
    }

    public static <E> boolean enqueueAll(Queue<? super E> queue, E ... array) {
        int len = array.length;
        return len != 0 && QueueTools.enqueueAll_(queue, array, len);
    }

    private static <E> boolean enqueueAll_(Queue<? super E> queue, E[] array, int arrayLength) {
        int i = 0;
        do {
            queue.enqueue(array[i++]);
        } while (i < arrayLength);
        return true;
    }

    public static <E> ArrayList<E> drain(Queue<? extends E> queue) {
        ArrayList result = new ArrayList();
        QueueTools.drainTo(queue, result);
        return result;
    }

    public static <E> boolean drainTo(Queue<? extends E> queue, Collection<? super E> collection) {
        return !queue.isEmpty() && QueueTools.drainTo_(queue, collection);
    }

    private static <E> boolean drainTo_(Queue<? extends E> queue, Collection<? super E> collection) {
        do {
            collection.add(queue.dequeue());
        } while (!queue.isEmpty());
        return true;
    }

    public static <E> boolean drainTo(Queue<? extends E> queue, List<? super E> list, int index) {
        return !queue.isEmpty() && QueueTools.drainTo_(queue, list, index);
    }

    private static <E> boolean drainTo_(Queue<? extends E> queue, List<? super E> list, int index) {
        return index == list.size() ? QueueTools.drainTo_(queue, list) : list.addAll(index, QueueTools.drain(queue));
    }

    public static <E> boolean drainTo(Queue<? extends E> queue, Stack<? super E> stack) {
        return !queue.isEmpty() && QueueTools.drainTo_(queue, stack);
    }

    private static <E> boolean drainTo_(Queue<? extends E> queue, Stack<? super E> stack) {
        do {
            stack.push(queue.dequeue());
        } while (!queue.isEmpty());
        return true;
    }

    public static <E> boolean drainTo(Queue<? extends E> queue1, Queue<? super E> queue2) {
        return !queue1.isEmpty() && QueueTools.drainTo_(queue1, queue2);
    }

    private static <E> boolean drainTo_(Queue<? extends E> queue1, Queue<? super E> queue2) {
        do {
            queue2.enqueue(queue1.dequeue());
        } while (!queue1.isEmpty());
        return true;
    }

    public static <K, V, E extends V> boolean drainTo(Queue<E> queue, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        return !queue.isEmpty() && QueueTools.drainTo_(queue, map, keyTransformer);
    }

    private static <K, V, E extends V> boolean drainTo_(Queue<E> queue, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        do {
            MapTools.add(map, queue.dequeue(), keyTransformer);
        } while (!queue.isEmpty());
        return true;
    }

    public static <K, V, E> boolean drainTo(Queue<E> queue, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        return !queue.isEmpty() && QueueTools.drainTo_(queue, map, keyTransformer, valueTransformer);
    }

    private static <K, V, E> boolean drainTo_(Queue<E> queue, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        do {
            MapTools.add(map, queue.dequeue(), keyTransformer, valueTransformer);
        } while (!queue.isEmpty());
        return true;
    }

    public static <E> ArrayQueue<E> arrayQueue() {
        return QueueTools.arrayQueue(10);
    }

    public static <E> ArrayQueue<E> arrayQueue(int initialCapacity) {
        return new ArrayQueue(initialCapacity);
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterable<? extends E> iterable) {
        return QueueTools.arrayQueue(iterable.iterator());
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterable<? extends E> iterable, int iterableSize) {
        return QueueTools.arrayQueue(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterator<? extends E> iterator) {
        ArrayQueue<E> result = QueueTools.arrayQueue();
        QueueTools.enqueueAll(result, iterator);
        return result;
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterator<? extends E> iterator, int iteratorSize) {
        ArrayQueue<E> result = QueueTools.arrayQueue(iteratorSize);
        QueueTools.enqueueAll(result, iterator);
        return result;
    }

    public static <E> ArrayQueue<E> arrayQueue(E ... array) {
        ArrayQueue<E> result = QueueTools.arrayQueue(array.length);
        QueueTools.enqueueAll(result, array);
        return result;
    }

    public static <E> LinkedQueue<E> linkedQueue() {
        return QueueTools.linkedQueue(0);
    }

    public static <E> LinkedQueue<E> linkedQueue(int cacheSize) {
        return new LinkedQueue(cacheSize);
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterable<? extends E> iterable) {
        return QueueTools.linkedQueue(iterable, 0);
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterable<? extends E> iterable, int cacheSize) {
        return QueueTools.linkedQueue(iterable.iterator(), cacheSize);
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterator<? extends E> iterator) {
        return QueueTools.linkedQueue(iterator, 0);
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterator<? extends E> iterator, int cacheSize) {
        LinkedQueue<E> result = QueueTools.linkedQueue(cacheSize);
        QueueTools.enqueueAll(result, iterator);
        return result;
    }

    public static <E> LinkedQueue<E> linkedQueue(E ... array) {
        return QueueTools.linkedQueue(array, 0);
    }

    public static <E> LinkedQueue<E> linkedQueue(E[] array, int cacheSize) {
        LinkedQueue<E> result = QueueTools.linkedQueue(cacheSize);
        QueueTools.enqueueAll(result, array);
        return result;
    }

    public static <E> FixedCapacityArrayQueue<E> fixedCapacityArrayQueue(int capacity) {
        return new FixedCapacityArrayQueue(capacity);
    }

    public static <E> FixedCapacityArrayQueue<E> fixedCapacityArrayQueue(Collection<? extends E> collection) {
        FixedCapacityArrayQueue<E> result = QueueTools.fixedCapacityArrayQueue(collection.size());
        QueueTools.enqueueAll(result, collection);
        return result;
    }

    public static <E> StackQueue<E> stackQueue() {
        return QueueTools.adapt(new ArrayStack());
    }

    public static <E> StackQueue<E> adapt(Stack<E> stack) {
        return new StackQueue<E>(stack);
    }

    public static <E extends Comparable<E>> PriorityQueue<E> priorityQueue() {
        return QueueTools.priorityQueue(10);
    }

    public static <E extends Comparable<E>> PriorityQueue<E> priorityQueue(int initialCapacity) {
        return QueueTools.priorityQueue(ComparatorTools.naturalComparator(), initialCapacity);
    }

    public static <E> PriorityQueue<E> priorityQueue(Comparator<? super E> comparator) {
        return QueueTools.priorityQueue(comparator, 10);
    }

    public static <E> PriorityQueue<E> priorityQueue(Comparator<? super E> comparator, int initialCapacity) {
        return new PriorityQueue<E>(comparator, initialCapacity);
    }

    public static <E extends Comparable<E>> PriorityQueue<E> priorityQueue(E[] initialElements) {
        return QueueTools.priorityQueue(initialElements, (int)(initialElements.length - 1));
    }

    public static <E extends Comparable<E>> PriorityQueue<E> priorityQueue(E[] initialElements, int size) {
        return QueueTools.priorityQueue(ComparatorTools.naturalComparator(), initialElements, size);
    }

    public static <E> PriorityQueue<E> priorityQueue(Comparator<? super E> comparator, E[] initialElements) {
        return QueueTools.priorityQueue(comparator, initialElements, initialElements.length - 1);
    }

    public static <E> PriorityQueue<E> priorityQueue(Comparator<? super E> comparator, E[] initialElements, int size) {
        return new PriorityQueue<E>(comparator, initialElements, size);
    }

    public static <E> SynchronizedQueue<E> synchronizedQueue() {
        ArrayQueue<E> queue = QueueTools.arrayQueue();
        return QueueTools.synchronizedQueue(queue);
    }

    public static <E> SynchronizedQueue<E> synchronizedQueue(Object mutex) {
        ArrayQueue<E> queue = QueueTools.arrayQueue();
        return QueueTools.synchronizedQueue(queue, mutex);
    }

    public static <E> SynchronizedQueue<E> synchronizedQueue(Queue<E> queue) {
        return new SynchronizedQueue<E>(queue);
    }

    public static <E> SynchronizedQueue<E> synchronizedQueue(Queue<E> queue, Object mutex) {
        return new SynchronizedQueue<E>(queue, mutex);
    }

    public static <E> DequeQueue<E> adapt(Deque<E> deque) {
        return new DequeQueue<E>(deque);
    }

    public static <E> ListQueue<E> adapt(List<E> list) {
        return new ListQueue<E>(list);
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.instance();
    }

    private QueueTools() {
        throw new UnsupportedOperationException();
    }
}

