/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.Activator;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentBuildpathUtil;
import org.eclipse.ldt.core.internal.buildpath.Messages;

public class LuaExecutionEnvironmentBuildpathContainer
implements IBuildpathContainer {
    private final IPath path;
    private String description;

    public LuaExecutionEnvironmentBuildpathContainer(String eeID, String eeVersion, IPath path) {
        this.path = path;
    }

    public IBuildpathEntry[] getBuildpathEntries() {
        try {
            List<IPath> eeBuildPathes = LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironmentBuildPath(this.path);
            ArrayList<IBuildpathEntry> arrayList = new ArrayList<IBuildpathEntry>(eeBuildPathes.size());
            if (!eeBuildPathes.isEmpty()) {
                for (IPath buildPath : eeBuildPathes) {
                    IBuildpathEntry libEntry = DLTKCore.newLibraryEntry((IPath)buildPath, (IAccessRule[])BuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])new IBuildpathAttribute[0], (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true);
                    arrayList.add(libEntry);
                }
                return arrayList.toArray(new IBuildpathEntry[arrayList.size()]);
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        return new IBuildpathEntry[0];
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        String id = null;
        String version = null;
        boolean isFromManifest = false;
        try {
            LuaExecutionEnvironment ee = LuaExecutionEnvironmentBuildpathUtil.getExecutionEnvironment(this.path);
            if (ee != null && ee.getID() != null) {
                id = ee.getID();
                version = ee.getVersion();
                isFromManifest = true;
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        if (id == null && version == null && this.path != null && this.path.segmentCount() > 2) {
            int length = this.path.segmentCount();
            id = this.path.segment(length - 2);
            version = this.path.segment(length - 1);
        }
        if (id != null && version != null) {
            StringBuffer sb = new StringBuffer();
            if (id.length() > 0) {
                sb.append(id.substring(0, 1).toUpperCase());
                if (id.length() > 1) {
                    sb.append(id.substring(1));
                }
                sb.append(' ');
            }
            sb.append(version);
            String result = sb.toString();
            if (isFromManifest) {
                this.description = result;
            } else {
                result = Messages.bind((String)Messages.LuaExecutionEnvironmentBuildpathContainerEENotFound, (Object)result);
            }
            return result;
        }
        return Messages.LuaExecutionEnvironmentBuildpathContainerNoDescriptionAvailable;
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.path;
    }
}

