/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.cs2as;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.context.AbstractBase2ASConversion;
import org.eclipse.ocl.pivot.internal.scoping.ScopeFilter;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MorePivotable;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.ocl.xtext.base.cs2as.BaseCSPreOrderVisitor;
import org.eclipse.ocl.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.xtext.base.cs2as.InterDependency;
import org.eclipse.ocl.xtext.base.cs2as.PivotDependency;
import org.eclipse.ocl.xtext.base.cs2as.ValidationDiagnostic;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.AnnotationElementCS;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ElementRefCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.OperationCS;
import org.eclipse.ocl.xtext.basecs.PackageCS;
import org.eclipse.ocl.xtext.basecs.ParameterCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.PivotableElementCS;
import org.eclipse.ocl.xtext.basecs.TemplateBindingCS;
import org.eclipse.ocl.xtext.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.xtext.basecs.TemplateSignatureCS;
import org.eclipse.ocl.xtext.basecs.TemplateableElementCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.basecs.TypedElementCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.basecs.WildcardTypeRefCS;
import org.eclipse.ocl.xtext.basecs.util.BaseCSVisitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class CS2ASConversion
extends AbstractBase2ASConversion {
    private static final Logger logger = Logger.getLogger(CS2ASConversion.class);
    public static final @NonNull TracingOption CONTINUATION = new TracingOption("org.eclipse.ocl.xtext.base", "continuation");
    protected final @NonNull CS2AS converter;
    private final @NonNull BaseCSVisitor<Continuation<?>> containmentVisitor;
    private final @NonNull BaseCSVisitor<Element> left2RightVisitor;
    private final @NonNull BaseCSVisitor<Continuation<?>> postOrderVisitor;
    private final @NonNull BaseCSVisitor<Continuation<?>> preOrderVisitor;
    private @NonNull InterDependency<@NonNull BaseCSPreOrderVisitor.TemplateSignatureContinuation> typesHaveSignatures = new InterDependency("All unspecialized signatures defined", null);
    private @NonNull InterDependency<@NonNull BaseCSPreOrderVisitor.OperatorExpContinuation<?>> operatorsHavePrecedence = new InterDependency("All operator precedences defined", null);
    private final @NonNull Map<CacheKey<?>, Object> intermediateCache = new HashMap();
    private Map<String, Package> oldPackagesByName = null;
    private Map<String, Package> oldPackagesByQualifiedName = null;
    private final IDiagnosticConsumer diagnosticsConsumer;
    private boolean hasFailed = false;

    public CS2ASConversion(@NonNull CS2AS converter, @NonNull IDiagnosticConsumer diagnosticsConsumer) {
        super(converter.getEnvironmentFactory());
        this.converter = converter;
        this.diagnosticsConsumer = diagnosticsConsumer;
        this.containmentVisitor = converter.createContainmentVisitor(this);
        this.left2RightVisitor = converter.createLeft2RightVisitor(this);
        this.postOrderVisitor = converter.createPostOrderVisitor(this);
        this.preOrderVisitor = converter.createPreOrderVisitor(this);
    }

    public @NonNull OCLExpression addBadExpressionError(@NonNull ModelElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
        InvalidLiteralExp invalidLiteralExp = this.metamodelManager.createInvalidExpression();
        csElement.setPivot((Element)invalidLiteralExp);
        return invalidLiteralExp;
    }

    @Deprecated
    public void addDiagnostic(@NonNull ModelElementCS csElement, @NonNull Diagnostic diagnostic) {
        this.addError(csElement, diagnostic.getMessage(), new Object[0]);
    }

    @Deprecated
    public void addDiagnostic(@NonNull ElementCS csElement, @NonNull String boundMessage) {
        this.addError(csElement, boundMessage, new Object[0]);
    }

    public void addError(@NonNull ElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getErrors().add((Object)resourceDiagnostic);
    }

    public void addWarning(@NonNull ModelElementCS csElement, String message, Object ... bindings) {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, boundMessage);
        csElement.eResource().getWarnings().add((Object)resourceDiagnostic);
    }

    public @NonNull String bind(@NonNull EObject csContext, String messageTemplate, Object ... bindings) {
        return this.converter.bind(csContext, messageTemplate, bindings);
    }

    public boolean checkForNoErrors(@NonNull BaseCSResource csResource) {
        @NonNull EList errors = csResource.getErrors();
        return !ElementUtil.hasSyntaxError((List<Resource.Diagnostic>)errors);
    }

    @Deprecated
    public Dependency createTypeIsReferenceableDependency(@NonNull TypeRefCS csTemplateParameter) {
        if (csTemplateParameter instanceof WildcardTypeRefCS) {
            return null;
        }
        return new PivotDependency(csTemplateParameter);
    }

    protected void diagnoseContinuationFailure(@NonNull List<BasicContinuation<?>> continuations) {
        if (CONTINUATION.isActive()) {
            for (BasicContinuation<?> continuation : continuations) {
                CONTINUATION.println((String)ClassUtil.nonNullState((Object)continuation.toString()));
                Dependency[] dependencyArray = continuation.getDependencies();
                int n = dependencyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Dependency dependency = dependencyArray[n2];
                    boolean canExecute = dependency.canExecute();
                    CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + dependency.toString());
                    ++n2;
                }
            }
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        for (BasicContinuation<?> continuation : continuations) {
            s.append("\n  ");
            s.append(continuation);
            Dependency[] dependencyArray = continuation.getDependencies();
            int n = dependencyArray.length;
            int n3 = 0;
            while (n3 < n) {
                Dependency dependency = dependencyArray[n3];
                s.append("\n    ");
                if (!dependency.canExecute()) {
                    s.append("BLOCKED ");
                    dependency.canExecute();
                }
                s.append(dependency);
                ++n3;
            }
            continuation.canExecute();
            if (++i < 10) continue;
            s.append("\n  ...");
            break;
        }
        logger.error((Object)("Failed to complete continuations" + s.toString()));
    }

    public void garbageCollect(@NonNull Map<? extends Resource, ? extends ASResource> cs2asResourceMap) {
        Object eObject;
        Object referencedOrphan;
        final ArrayList<? extends ASResource> prunableResources = new ArrayList<ASResource>(cs2asResourceMap.values());
        ArrayList<Object> allPivotResources = new ArrayList<Object>((Collection<Object>)this.metamodelManager.getASResourceSet().getResources());
        EObject lockingObject = this.metamodelManager.getLockingObject();
        if (lockingObject != null) {
            allPivotResources.add(lockingObject);
        }
        allPivotResources.addAll(this.metamodelManager.getLibraries());
        allPivotResources.addAll(cs2asResourceMap.keySet());
        allPivotResources.remove(this.metamodelManager.getCompleteModel().getOrphanage().eResource());
        EcoreUtil.CrossReferencer referencesToOrphans = new EcoreUtil.CrossReferencer(allPivotResources){
            {
                super($anonymous0);
                this.crossReference();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                Resource eResource = crossReferencedEObject.eResource();
                boolean isPrunable = prunableResources.contains(eResource);
                return isPrunable;
            }

            protected void handleCrossReference(EObject eObject) {
                try {
                    super.handleCrossReference(eObject);
                    InternalEObject internalEObject = (InternalEObject)eObject;
                    for (EObject eContent : eObject.eContents()) {
                        EReference eReference = (EReference)eContent.eContainingFeature();
                        this.add(internalEObject, eReference, eContent);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            protected boolean resolve() {
                return false;
            }
        };
        HashSet<Object> wantedOrphans = new HashSet<Object>();
        ArrayList<Map.Entry> suspects = new ArrayList<Map.Entry>();
        for (Map.Entry entry : referencesToOrphans.entrySet()) {
            referencedOrphan = (EObject)entry.getKey();
            Collection referencesToOrphan = (Collection)entry.getValue();
            boolean wantIt = false;
            for (EStructuralFeature.Setting setting : referencesToOrphan) {
                eObject = setting.getEObject();
                Resource eResource = eObject.eResource();
                if (prunableResources.contains(eResource)) continue;
                wantedOrphans.add(referencedOrphan);
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            suspects.add(entry);
        }
        while (!suspects.isEmpty()) {
            ArrayList<Map.Entry> arrayList = suspects;
            suspects = new ArrayList();
            for (Map.Entry entry : arrayList) {
                EObject referencedOrphan2 = (EObject)entry.getKey();
                Collection referencesToOrphan = (Collection)entry.getValue();
                boolean wantIt = false;
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    EObject eObject2 = setting.getEObject();
                    if (!wantedOrphans.contains(eObject2)) continue;
                    wantedOrphans.add(referencedOrphan2);
                    wantIt = true;
                    break;
                }
                if (wantIt) continue;
                suspects.add(entry);
            }
            if (arrayList.size() <= suspects.size()) break;
        }
        for (Map.Entry entry : suspects) {
            EObject eContainer;
            referencedOrphan = (EObject)entry.getKey();
            boolean wantIt = false;
            for (EObject eChild : referencedOrphan.eContents()) {
                if (!wantedOrphans.contains(eChild)) continue;
                wantIt = true;
                break;
            }
            if (wantIt) continue;
            Collection referencesToOrphan = (Collection)entry.getValue();
            if (referencesToOrphan != null) {
                for (EStructuralFeature.Setting setting : referencesToOrphan) {
                    eObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature.isMany()) {
                        Collection list = (Collection)eObject.eGet(eStructuralFeature);
                        list.remove(referencedOrphan);
                        continue;
                    }
                    eObject.eSet(eStructuralFeature, null);
                }
            }
            if ((eContainer = referencedOrphan.eContainer()) == null) continue;
            PivotUtil.debugObjectUsage((String)"  container ", (EObject)eContainer);
            referencedOrphan.eSet(referencedOrphan.eContainingFeature(), null);
        }
    }

    protected void gatherNewPackage(@NonNull Set<Package> newPackages, @NonNull EObject pivot) {
        EObject eContainer;
        if (pivot instanceof Package) {
            newPackages.add((Package)pivot);
        }
        if ((eContainer = pivot.eContainer()) != null) {
            this.gatherNewPackage(newPackages, eContainer);
        }
    }

    protected void gatherNewPackages(@NonNull Set<Package> newPackages, @NonNull Resource csResource) {
        TreeIterator tit = csResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Pivotable)) continue;
            Element pObject = ((Pivotable)eObject).getPivot();
            if (pObject instanceof Package) {
                this.gatherNewPackage(newPackages, (EObject)pObject);
            } else if (pObject instanceof Model) {
                this.gatherNewPackage(newPackages, (EObject)pObject);
            } else {
                if (pObject instanceof Type) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Operation) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                } else if (pObject instanceof Property) {
                    this.gatherNewPackage(newPackages, (EObject)pObject);
                }
                tit.prune();
            }
            if (!(eObject instanceof MorePivotable)) continue;
            for (Element pivot : ((MorePivotable)eObject).getMorePivots()) {
                if (pivot == null) continue;
                this.gatherNewPackage(newPackages, (EObject)pivot);
            }
        }
    }

    protected void gatherOldPackages(@NonNull List<? extends @NonNull Package> pkgs) {
        for (Package package_ : pkgs) {
            String qualifiedName;
            Package oldPkg;
            String name = package_.getName();
            if (name == null) {
                name = "$null$";
            }
            if ((oldPkg = this.oldPackagesByQualifiedName.put(qualifiedName = this.getQualifiedName(new StringBuilder(), package_), package_)) != null) {
                logger.warn((Object)("Duplicate qualified package name: " + qualifiedName));
            }
            if (name.equals(qualifiedName)) {
                oldPkg = this.oldPackagesByName.put(name, package_);
                if (oldPkg != null && name.equals(this.getQualifiedName(new StringBuilder(), oldPkg))) {
                    logger.warn((Object)("Duplicate unqualified package name: " + qualifiedName));
                }
            } else {
                oldPkg = this.oldPackagesByName.get(name);
                if (oldPkg == null) {
                    this.oldPackagesByName.put(name, package_);
                }
            }
            @NonNull List nestedPackage = package_.getOwnedPackages();
            this.gatherOldPackages(nestedPackage);
        }
    }

    public final @NonNull CS2AS getConverter() {
        return this.converter;
    }

    public final @NonNull PivotHelper getHelper() {
        return this.converter.getHelper();
    }

    public <T> T getIntermediate(@NonNull CacheKey<T> key) {
        return (T)this.intermediateCache.get(key);
    }

    public <T extends Element> List<T> getNewPivotElements(@NonNull java.lang.Class<T> pivotClass, Iterable<? extends ModelElementCS> csElements) {
        assert (csElements != null);
        ArrayList<Element> newPivotElements = new ArrayList<Element>();
        for (ModelElementCS modelElementCS : csElements) {
            @Nullable Element pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)modelElementCS);
            if (pivotElement == null) continue;
            newPivotElements.add(pivotElement);
        }
        return newPivotElements;
    }

    public @Nullable Package getOldPackageByQualifiedName(@NonNull PackageCS csElement) {
        String qualifiedName = this.getQualifiedName(new StringBuilder(), csElement);
        return this.oldPackagesByQualifiedName.get(qualifiedName);
    }

    public @Nullable Package getOldPackageBySimpleName(@NonNull String name) {
        return this.oldPackagesByName.get(name);
    }

    public @NonNull InterDependency<@NonNull BaseCSPreOrderVisitor.OperatorExpContinuation<?>> getOperatorsHavePrecedenceInterDependency() {
        return this.operatorsHavePrecedence;
    }

    protected @NonNull String getQualifiedName(@NonNull StringBuilder s, @NonNull Package pkg) {
        String name;
        Package nestingPackage = pkg.getOwningPackage();
        if (nestingPackage != null) {
            this.getQualifiedName(s, nestingPackage);
            s.append("$$");
        }
        if ((name = pkg.getName()) == null) {
            name = "$null$";
        }
        s.append(name);
        return s.toString();
    }

    protected @NonNull String getQualifiedName(@NonNull StringBuilder s, @NonNull PackageCS csPackage) {
        String name;
        EObject eContainer = csPackage.eContainer();
        if (eContainer instanceof PackageCS) {
            this.getQualifiedName(s, (PackageCS)eContainer);
            s.append("$$");
        }
        if ((name = csPackage.getName()) == null) {
            URI csURI;
            Resource csResource;
            name = "$null$";
            if (eContainer == null && (csResource = csPackage.eResource()) != null && (csURI = csResource.getURI()) != null) {
                name = csURI.lastSegment();
            }
        }
        s.append(name);
        return s.toString();
    }

    protected @NonNull List<TemplateBindingCS> getTemplateBindings(@NonNull ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    protected @NonNull List<TemplateSignature> getTemplateSignatures(@NonNull Element pivotElement) {
        TemplateableElement templateableElement;
        TemplateSignature templateSignature;
        EObject container = pivotElement.eContainer();
        List<Object> pivotTemplateSignatures = container instanceof Element ? this.getTemplateSignatures((Element)container) : new ArrayList();
        if (pivotElement instanceof TemplateableElement && (templateSignature = (templateableElement = (TemplateableElement)pivotElement).getOwnedSignature()) != null) {
            pivotTemplateSignatures.add(templateSignature);
        }
        return pivotTemplateSignatures;
    }

    public @NonNull InterDependency<@NonNull BaseCSPreOrderVisitor.TemplateSignatureContinuation> getTypesHaveSignaturesInterDependency() {
        return this.typesHaveSignatures;
    }

    public void handleVisitNamedElement(@NonNull NamedElementCS csNamedElement, @NonNull NamedElement pivotElement) {
        List pivotAnnotations = pivotElement.getOwnedAnnotations();
        EList<AnnotationElementCS> csAnnotations = csNamedElement.getOwnedAnnotations();
        this.refreshPivotList((java.lang.Class)Annotation.class, pivotAnnotations, (Iterable<? extends ModelElementCS>)csAnnotations);
    }

    public void installPivotReference(@NonNull ElementRefCS csElement, @NonNull Element newPivotElement, EReference eReference) {
        assert (eReference != null);
        this.converter.installPivotReference(csElement, newPivotElement, eReference);
    }

    public void installPivotUsage(@NonNull ModelElementCS csElement, @NonNull Element newPivotElement) {
        this.converter.installPivotUsage(csElement, newPivotElement);
    }

    protected void installRootContents(@NonNull BaseCSResource csResource) {
        for (EObject eObject : csResource.getContents()) {
            Resource asResource;
            Element pivotElement;
            if (!(eObject instanceof Pivotable) || (pivotElement = ((Pivotable)eObject).getPivot()) == null || (asResource = pivotElement.eResource()) != null) continue;
            this.installRootElement(csResource, pivotElement);
        }
    }

    public void installPivotTypeWithMultiplicity(@Nullable Type pivotType, @NonNull TypedRefCS csElement) {
        if (pivotType == null || pivotType.eIsProxy()) {
            pivotType = this.getStandardLibrary().getOclInvalidType();
        }
        boolean isNullFree = false;
        int lower = pivotType instanceof MapType ? 1 : 0;
        int upper = 1;
        MultiplicityCS multiplicity = csElement.getOwnedMultiplicity();
        if (multiplicity != null) {
            isNullFree = multiplicity.isIsNullFree();
            lower = multiplicity.getLower();
            upper = multiplicity.getUpper();
        }
        if (upper == 1) {
            this.installPivotReference(csElement, (Element)pivotType, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        } else {
            boolean isOrdered = false;
            boolean isUnique = false;
            EObject eContainer = csElement.eContainer();
            if (eContainer instanceof TypedElementCS) {
                isOrdered = ElementUtil.isOrdered((TypedElementCS)eContainer);
                isUnique = ElementUtil.isUnique((TypedElementCS)eContainer);
            }
            IntegerValue lowerValue = ValueUtil.integerValueOf((int)lower);
            UnlimitedValue upperValue = upper != -1 ? ValueUtil.unlimitedNaturalValueOf((int)upper) : ValueUtil.UNLIMITED_VALUE;
            CollectionType pivotCollectionType = this.metamodelManager.getCollectionType(isOrdered, isUnique, pivotType, isNullFree, lowerValue, (UnlimitedNaturalValue)upperValue);
            this.installPivotReference(csElement, (Element)pivotCollectionType, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
        }
    }

    public void installRootElement(@NonNull BaseCSResource csResource, @NonNull Element pivotElement) {
        ASResource asResource = this.converter.getASResource();
        asResource.getContents().add((Object)pivotElement);
        this.metamodelManager.installResource((Resource)asResource);
    }

    public boolean isInReturnTypeWithUnresolvedParameters(@NonNull ElementCS csElement) {
        OperationCS csOperation = null;
        ElementCS eObject = csElement;
        EObject eContainer = csElement.eContainer();
        while (true) {
            if (eContainer == null) {
                return false;
            }
            if (eContainer instanceof OperationCS) {
                csOperation = (OperationCS)eContainer;
                if (eObject == csOperation.getOwnedType()) break;
                return false;
            }
            eObject = eContainer;
            eContainer = eContainer.eContainer();
        }
        if (csOperation == null) {
            return false;
        }
        for (ParameterCS csParameter : csOperation.getOwnedParameters()) {
            Parameter pivot = (Parameter)PivotUtil.getPivot(Parameter.class, (Pivotable)csParameter);
            if (pivot == null) {
                return true;
            }
            if (pivot.getType() != null) continue;
            return true;
        }
        return false;
    }

    public @Nullable Boolean isRequired(@NonNull TypedRefCS csTypeRef) {
        return this.converter.isRequired(csTypeRef);
    }

    public @Nullable Iteration lookupIteration(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        return this.converter.lookupIteration(csElement, csPathName, scopeFilter);
    }

    public @Nullable Operation lookupOperation(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        return this.converter.lookupOperation(csElement, csPathName, scopeFilter);
    }

    public @Nullable Property lookupProperty(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName, @Nullable ScopeFilter scopeFilter) {
        return this.converter.lookupProperty(csElement, csPathName, scopeFilter);
    }

    public @Nullable Type lookupType(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        return this.converter.lookupType(csElement, csPathName);
    }

    public @Nullable Type lookupTypeValue(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        return this.converter.lookupTypeValue(csElement, csPathName);
    }

    public @Nullable Element lookupUndecoratedName(@NonNull ElementCS csElement, @NonNull PathNameCS csPathName) {
        return this.converter.lookupUndecoratedName(csElement, csPathName);
    }

    protected @Nullable List<BasicContinuation<?>> progressContinuations(@NonNull List<BasicContinuation<?>> continuations) {
        ArrayList moreContinuations = new ArrayList();
        boolean madeProgress = false;
        boolean tracingOn = CONTINUATION.isActive();
        if (tracingOn) {
            CONTINUATION.println("------------------------------------------------ " + continuations.size());
            CONTINUATION.println((String)ClassUtil.nonNullState((Object)this.typesHaveSignatures.toString()));
        }
        for (BasicContinuation<?> continuation : continuations) {
            boolean canExecute = continuation.canExecute();
            if (tracingOn) {
                CONTINUATION.println(String.valueOf(canExecute ? "+ " : "- ") + continuation);
            }
            if (canExecute) {
                madeProgress = true;
                BasicContinuation<?> nextContinuation = continuation.execute();
                if (nextContinuation == null) continue;
                nextContinuation.addTo(moreContinuations);
                continue;
            }
            moreContinuations.add(continuation);
        }
        return madeProgress ? moreContinuations : null;
    }

    public <T> T putIntermediate(CacheKey<T> key, T object) {
        return (T)this.intermediateCache.put(key, object);
    }

    public void refreshComments(Element pivotElement, ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        if (node != null) {
            List<ILeafNode> documentationNodes = CS2AS.getDocumentationNodes(node);
            List ownedComments = pivotElement.getOwnedComments();
            if (documentationNodes != null) {
                int i = 0;
                if (documentationNodes.size() == 1 && "/**/".equals(documentationNodes.get(0).getText())) {
                    Comment comment = PivotFactory.eINSTANCE.createComment();
                    comment.setBody(null);
                    ownedComments.add(comment);
                    i = 1;
                } else {
                    Comment comment;
                    String trimmedString;
                    String string;
                    ArrayList<String> documentationStrings = new ArrayList<String>();
                    for (ILeafNode documentationNode : documentationNodes) {
                        String text = documentationNode.getText().replace("\r", "");
                        if (text.startsWith("/*") && text.endsWith("*/")) {
                            StringBuilder s = new StringBuilder();
                            String contentString = text.substring(2, text.length() - 2).trim();
                            String[] stringArray = contentString.split("\n");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String string2 = stringArray[n2];
                                String trimmedString2 = string2.trim();
                                if (s.length() > 0) {
                                    s.append("\n");
                                }
                                s.append(trimmedString2.startsWith("*") ? trimmedString2.substring(1).trim() : trimmedString2);
                                ++n2;
                            }
                            documentationStrings.add(s.toString());
                            continue;
                        }
                        documentationStrings.add(text.trim());
                    }
                    int iMax = Math.min(documentationStrings.size(), ownedComments.size());
                    while (i < iMax) {
                        string = (String)documentationStrings.get(i);
                        if (string != null && !(trimmedString = string).equals((comment = (Comment)ownedComments.get(i)).getBody())) {
                            comment.setBody(trimmedString);
                        }
                        ++i;
                    }
                    while (i < documentationStrings.size()) {
                        string = (String)documentationStrings.get(i);
                        if (string != null) {
                            trimmedString = string;
                            comment = PivotFactory.eINSTANCE.createComment();
                            comment.setBody(trimmedString);
                            ownedComments.add(comment);
                        }
                        ++i;
                    }
                }
                while (i < ownedComments.size()) {
                    ownedComments.remove(ownedComments.size() - 1);
                }
            } else if (ownedComments.size() > 0) {
                ownedComments.clear();
            }
        }
    }

    public void refreshContextVariable(@NonNull ElementCS csElement, @NonNull ExpressionInOCL pivotSpecification) {
        EObject eContainer = pivotSpecification.eContainer();
        EStructuralFeature eContainingFeature = pivotSpecification.eContainingFeature();
        if (eContainer == null || eContainingFeature == null) {
            this.addError(csElement, "No context container for: " + pivotSpecification, new Object[0]);
        } else if (eContainingFeature == PivotPackage.Literals.CONSTRAINT__OWNED_SPECIFICATION) {
            Constraint contextConstraint = (Constraint)eContainer;
            eContainer = contextConstraint.eContainer();
            eContainingFeature = contextConstraint.eContainingFeature();
            if (eContainingFeature == PivotPackage.Literals.CLASS__OWNED_INVARIANTS) {
                Type contextType = (Type)eContainer;
                if (contextType != null) {
                    this.setClassifierContext(pivotSpecification, contextType);
                }
                this.setContextVariable(pivotSpecification, "self", contextType, null);
            } else if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_PRECONDITIONS) {
                Operation contextOperation = (Operation)eContainer;
                if (contextOperation != null) {
                    this.setContextVariable(pivotSpecification, "self", (Type)contextOperation.getOwningClass(), null);
                    this.setOperationContext(pivotSpecification, contextOperation, null);
                } else {
                    this.setContextVariable(pivotSpecification, "self", null, null);
                }
            } else if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_POSTCONDITIONS) {
                Operation contextOperation = (Operation)eContainer;
                if (contextOperation != null) {
                    this.setContextVariable(pivotSpecification, "self", (Type)contextOperation.getOwningClass(), null);
                    this.setOperationContext(pivotSpecification, contextOperation, "result");
                } else {
                    this.setContextVariable(pivotSpecification, "self", null, null);
                }
            } else {
                this.addError(csElement, "Unsupported refreshContextVariable for a constraint: " + eContainingFeature, new Object[0]);
            }
        } else if (eContainingFeature == PivotPackage.Literals.PROPERTY__OWNED_EXPRESSION) {
            Property contextProperty = (Property)eContainer;
            this.setPropertyContext(pivotSpecification, contextProperty);
            this.setContextVariable(pivotSpecification, "self", (Type)contextProperty.getOwningClass(), null);
        } else if (eContainingFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
            Operation contextOperation = (Operation)eContainer;
            this.setContextVariable(pivotSpecification, "self", (Type)contextOperation.getOwningClass(), null);
            this.setOperationContext(pivotSpecification, contextOperation, null);
        } else {
            this.addError(csElement, "Unsupported refreshContextVariable for a specification: " + eContainingFeature, new Object[0]);
        }
    }

    public <T extends Element> void refreshList(@NonNull java.lang.Class<T> pivotClass, List<T> pivotElements, List<? extends PivotableElementCS> csElements) {
        assert (csElements != null);
        if (!pivotElements.isEmpty() || !csElements.isEmpty()) {
            ArrayList<Element> newPivotElements = new ArrayList<Element>();
            for (PivotableElementCS pivotableElementCS : csElements) {
                @Nullable Object pivotElement = PivotUtil.getPivot(pivotClass, (Pivotable)pivotableElementCS);
                if (pivotElement == null && pivotableElementCS instanceof ModelElementCS) {
                    pivotElement = this.converter.getPivotElement(pivotClass, (ModelElementCS)pivotableElementCS);
                }
                if (pivotElement == null || newPivotElements.contains(pivotElement)) continue;
                newPivotElements.add((Element)pivotElement);
            }
            PivotUtilInternal.refreshList(pivotElements, newPivotElements);
        }
    }

    public <T extends Element> @NonNull T refreshModelElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @Nullable ModelElementCS csElement) {
        assert (pivotEClass != null);
        return this.converter.refreshModelElement(pivotClass, pivotEClass, csElement);
    }

    @Deprecated
    public void refreshName(@NonNull NamedElement pivotNamedElement, @Nullable String newName) {
        this.getHelper().refreshName(pivotNamedElement, newName);
    }

    @Deprecated
    public void refreshNsURI(@NonNull Package pivotPackage, String newNsURI) {
        this.getHelper().refreshNsURI(pivotPackage, newNsURI);
    }

    public <T extends Element> void refreshPivotList(@NonNull java.lang.Class<T> pivotClass, List<? super T> pivotElements, Iterable<? extends ModelElementCS> csElements) {
        assert (pivotElements != null);
        assert (csElements != null);
        if (pivotElements.isEmpty() && Iterables.isEmpty(csElements)) {
            return;
        }
        List<T> newPivotElements = this.getNewPivotElements(pivotClass, csElements);
        PivotUtilInternal.refreshList(pivotElements, newPivotElements);
    }

    public Type refreshRequiredType(@NonNull TypedElement pivotElement, @NonNull TypedElementCS csTypedElement) {
        TypedRefCS ownedType = csTypedElement.getOwnedType();
        Type pivotType = null;
        boolean isRequired = false;
        if (ownedType != null) {
            pivotType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)ownedType);
            if (pivotType instanceof MapType) {
                boolean lower = true;
                boolean upper = true;
                isRequired = true;
            } else {
                int lower = ElementUtil.getLower(csTypedElement);
                int upper = ElementUtil.getUpper(csTypedElement);
                isRequired = upper == 1 ? lower == 1 : true;
            }
        }
        if (pivotType == null) {
            pivotType = this.metamodelManager.getStandardLibrary().getOclVoidType();
            isRequired = false;
        }
        this.getHelper().setType(pivotElement, pivotType, isRequired);
        return pivotType;
    }

    public void refreshRequiredType(@NonNull TypedElement pivotElement, @NonNull TypedRefCS csTypeRef) {
        Class type = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csTypeRef);
        Boolean isRequired = this.converter.isRequired(csTypeRef);
        this.getHelper().setType(pivotElement, (Type)type, isRequired == Boolean.TRUE);
    }

    public void refreshTemplateSignature(@NonNull TemplateableElementCS csTemplateableElement, @NonNull TemplateableElement pivotTemplateableElement) {
        TemplateSignatureCS csTemplateSignature = csTemplateableElement.getOwnedSignature();
        if (csTemplateSignature == null) {
            if (pivotTemplateableElement.getOwnedSignature() != null) {
                pivotTemplateableElement.setOwnedSignature(null);
            }
            return;
        }
        TemplateSignature pivotTemplateSignature = (TemplateSignature)PivotUtil.getPivot(TemplateSignature.class, (Pivotable)csTemplateSignature);
        if (pivotTemplateableElement.getOwnedSignature() != pivotTemplateSignature) {
            pivotTemplateableElement.setOwnedSignature(pivotTemplateSignature);
        }
    }

    protected void resetPivotMappings(@NonNull BaseCSResource csResource) {
        TreeIterator tit = csResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Pivotable)) continue;
            Pivotable pivotable = (Pivotable)eObject;
            pivotable.resetPivot();
        }
    }

    @Deprecated
    public void setBehavioralType(@NonNull TypedElement targetElement, @NonNull TypedElement sourceElement) {
        this.getHelper().setBehavioralType(targetElement, sourceElement);
    }

    @Deprecated
    public void setContextVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull String selfVariableName, @Nullable Type contextType, @Nullable Type contextInstance) {
        this.getHelper().setContextVariable(pivotSpecification, selfVariableName, contextType, contextInstance);
    }

    public void setReferredIteration(@NonNull LoopExp expression, @Nullable Iteration iteration) {
        expression.setReferredIteration(iteration);
        expression.setName(iteration != null ? iteration.getName() : null);
    }

    public void setReferredOperation(@NonNull OperationCallExp expression, @Nullable Operation operation) {
        expression.setReferredOperation(operation);
        expression.setName(operation != null ? operation.getName() : null);
    }

    @Deprecated
    public void setType(@NonNull OCLExpression pivotElement, Type type, boolean isRequired, @Nullable Type typeValue) {
        this.getHelper().setType(pivotElement, type, isRequired, typeValue);
    }

    @Deprecated
    public void setType(@NonNull VariableDeclaration pivotElement, Type type, boolean isRequired, @Nullable Type typeValue) {
        this.getHelper().setType(pivotElement, type, isRequired, typeValue);
    }

    @Deprecated
    public void setType(@NonNull TypedElement pivotElement, Type type, boolean isRequired) {
        this.getHelper().setType(pivotElement, type, isRequired);
    }

    protected void specializeTemplateBindings(@NonNull List<TemplateBinding> templateBindings, @NonNull List<TemplateSignature> templateSignatures, @NonNull List<TemplateBindingCS> csTemplateBindings) {
        int pivotIMax;
        int csIMax = csTemplateBindings.size();
        if (csIMax != (pivotIMax = templateSignatures.size())) {
            TypedTypeRefCS owningTemplateBindableElement = csTemplateBindings.get(0).getOwningElement();
            String string = owningTemplateBindableElement != null ? owningTemplateBindableElement.toString() : "<null>";
            logger.warn((Object)("Inconsistent template bindings size for " + string));
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            TemplateBindingCS csTemplateBinding = csTemplateBindings.get(i);
            if (csTemplateBinding != null) {
                TemplateSignature templateSignature = templateSignatures.get(i);
                int oldMax = templateBindings.size();
                TemplateBinding templateBinding = null;
                int j = i;
                while (j < oldMax) {
                    TemplateBinding oldTemplateBinding = templateBindings.get(j);
                    if (oldTemplateBinding.getTemplateSignature() == templateSignature) {
                        if (j != i) {
                            templateBindings.add(i, templateBindings.remove(j));
                        }
                        templateBinding = oldTemplateBinding;
                        break;
                    }
                    ++j;
                }
                if (templateBinding == null) {
                    templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
                    assert (templateBinding != null);
                    if (i < oldMax) {
                        templateBindings.add(i, templateBinding);
                    } else {
                        templateBindings.add(templateBinding);
                    }
                }
                this.installPivotReference(csTemplateBinding, (Element)templateBinding, BaseCSPackage.Literals.PIVOTABLE_ELEMENT_CS__PIVOT);
                @NonNull List parameterSubstitutions = templateBinding.getOwnedSubstitutions();
                @NonNull List templateParameters = templateSignature.getOwnedParameters();
                @NonNull EList<TemplateParameterSubstitutionCS> csParameterSubstitutions = csTemplateBinding.getOwnedSubstitutions();
                this.specializeTemplateParameterSubstitutions(parameterSubstitutions, templateParameters, (List<TemplateParameterSubstitutionCS>)csParameterSubstitutions);
                assert (templateSignatures.get(i) == templateBindings.get(i).getTemplateSignature());
            }
            ++i;
        }
        int k = templateBindings.size();
        while (k > newMax) {
            templateBindings.remove(--k);
        }
        assert (templateSignatures.size() == templateBindings.size());
    }

    protected void specializeTemplateParameterSubstitutions(@NonNull List<TemplateParameterSubstitution> templateParameterSubstitutions, @NonNull List<TemplateParameter> templateParameters, @NonNull List<TemplateParameterSubstitutionCS> csTemplateParameterSubstitutions) {
        int pivotIMax;
        int csIMax = csTemplateParameterSubstitutions.size();
        if (csIMax != (pivotIMax = templateParameters.size())) {
            logger.warn((Object)"Inconsistent template parameter substitutions size");
        }
        int newMax = Math.min(csIMax, pivotIMax);
        int i = 0;
        while (i < newMax) {
            TypeRefCS csActualParameter;
            @NonNull TemplateParameterSubstitutionCS csTemplateParameterSubstitution = csTemplateParameterSubstitutions.get(i);
            TemplateParameter templateParameter = templateParameters.get(i);
            int oldMax = templateParameterSubstitutions.size();
            TemplateParameterSubstitution templateParameterSubstitution = null;
            int j = i;
            while (j < oldMax) {
                TemplateParameterSubstitution oldTemplateParameterSubstitution = templateParameterSubstitutions.get(j);
                if (oldTemplateParameterSubstitution.getFormal() == templateParameter) {
                    if (j != i) {
                        templateParameterSubstitutions.add(i, templateParameterSubstitutions.remove(j));
                    }
                    templateParameterSubstitution = oldTemplateParameterSubstitution;
                    this.converter.installPivotDefinition(csTemplateParameterSubstitution, (Element)templateParameterSubstitution);
                    break;
                }
                ++j;
            }
            if (templateParameterSubstitution == null) {
                templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
                templateParameterSubstitution.setFormal(templateParameter);
                if (i < oldMax) {
                    templateParameterSubstitutions.add(i, templateParameterSubstitution);
                } else {
                    templateParameterSubstitutions.add(templateParameterSubstitution);
                }
            }
            if ((csActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter()) instanceof WildcardTypeRefCS) {
                templateParameterSubstitution.setActual(null);
            } else {
                Type pivotActualParameter = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csActualParameter);
                templateParameterSubstitution.setActual(pivotActualParameter);
            }
            this.converter.installPivotDefinition(csTemplateParameterSubstitution, (Element)templateParameterSubstitution);
            assert (templateParameters.get(i) == templateParameterSubstitutions.get(i).getFormal());
            ++i;
        }
        int k = templateParameterSubstitutions.size();
        while (k > newMax) {
            templateParameterSubstitutions.remove(--k);
        }
        assert (templateParameters.size() == templateParameterSubstitutions.size());
    }

    protected @Nullable TemplateableElement specializeTemplates(@NonNull TypedTypeRefCS csElement) {
        TemplateBindingCS ownedTemplateBinding = csElement.getOwnedBinding();
        assert (ownedTemplateBinding != null);
        Class unspecializedPivotElement = (Class)csElement.getReferredType();
        if (unspecializedPivotElement == null || unspecializedPivotElement.eIsProxy()) {
            String moniker = csElement.toString();
            this.addError(csElement, "Nothing to specialize as " + moniker, new Object[0]);
            return null;
        }
        Class specializedPivotElement = (Class)PivotUtil.getPivot(Class.class, (Pivotable)csElement);
        if (specializedPivotElement == null) {
            if (unspecializedPivotElement instanceof CollectionType) {
                TemplateParameterSubstitutionCS csTemplateParameterSubstitution = (TemplateParameterSubstitutionCS)ownedTemplateBinding.getOwnedSubstitutions().get(0);
                Type templateArgument = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution.getOwnedActualParameter());
                boolean isNullFree = true;
                MultiplicityCS csMultiplicity = ownedTemplateBinding.getOwnedMultiplicity();
                if (csMultiplicity != null) {
                    isNullFree = csMultiplicity.isIsNullFree();
                }
                specializedPivotElement = templateArgument != null ? this.completeEnvironment.getCollectionType((CollectionType)unspecializedPivotElement, templateArgument, isNullFree, null, null) : unspecializedPivotElement;
            } else {
                ArrayList<@NonNull Type> templateArguments = new ArrayList<Type>();
                for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : ownedTemplateBinding.getOwnedSubstitutions()) {
                    Type templateArgument = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTemplateParameterSubstitution.getOwnedActualParameter());
                    if (templateArgument == null) continue;
                    templateArguments.add(templateArgument);
                }
                specializedPivotElement = this.metamodelManager.getLibraryType(unspecializedPivotElement, templateArguments);
            }
        }
        this.installPivotReference(csElement, (Element)specializedPivotElement, BaseCSPackage.Literals.TYPED_TYPE_REF_CS__REFERRED_TYPE);
        if (specializedPivotElement != unspecializedPivotElement) {
            @NonNull List templateBindings = specializedPivotElement.getOwnedBindings();
            List<TemplateSignature> templateSignatures = this.getTemplateSignatures((Element)unspecializedPivotElement);
            List<TemplateBindingCS> csTemplateBindings = this.getTemplateBindings(csElement);
            this.specializeTemplateBindings(templateBindings, templateSignatures, csTemplateBindings);
        }
        return specializedPivotElement;
    }

    /*
     * Unable to fully structure code
     */
    public boolean update(@NonNull BaseCSResource csResource) {
        this.resetPivotMappings(csResource);
        this.oldPackagesByName = new HashMap<String, Package>();
        this.oldPackagesByQualifiedName = new HashMap<String, Package>();
        asResource = this.converter.csi2asMapping.getASResource(csResource);
        if (asResource != null) {
            for (EObject eObject : asResource.getContents()) {
                if (!(eObject instanceof Model)) continue;
                nestedPackage = ((Model)eObject).getOwnedPackages();
                this.gatherOldPackages(nestedPackage);
            }
        }
        continuations = new ArrayList<BasicContinuation<?>>();
        for (EObject eObject : csResource.getContents()) {
            if (!(eObject instanceof ElementCS)) continue;
            this.visitContainment((ElementCS)eObject, continuations);
        }
        this.installRootContents(csResource);
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(csResource);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        for (EObject eObject : csResource.getContents()) {
            if (!(eObject instanceof ElementCS)) continue;
            this.visitInPreOrder((ElementCS)eObject, continuations);
        }
        while (continuations.size() > 0) {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                hasNoErrors = this.checkForNoErrors(csResource);
                if (!hasNoErrors) {
                    return false;
                }
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
        }
        oclAnyType = this.metamodelManager.getStandardLibrary().getOclAnyType();
        for (EObject eObject : csResource.getContents()) {
            if (!(eObject instanceof ElementCS)) continue;
            this.visitInPostOrder((ElementCS)eObject, continuations);
        }
        hasNoErrors = this.checkForNoErrors(csResource);
        if (hasNoErrors) ** GOTO lbl54
        return false;
lbl-1000:
        // 1 sources

        {
            moreContinuations = this.progressContinuations(continuations);
            if (moreContinuations == null) {
                this.diagnoseContinuationFailure(continuations);
                break;
            }
            continuations = moreContinuations;
lbl54:
            // 2 sources

            ** while (continuations.size() > 0)
        }
lbl55:
        // 2 sources

        this.installRootContents(csResource);
        this.converter.installRootContents(csResource);
        hasNoMoreErrors = this.checkForNoErrors(csResource);
        if (!hasNoMoreErrors) {
            return false;
        }
        newPackages = new HashSet<Package>();
        this.gatherNewPackages(newPackages, (Resource)csResource);
        obsoletePackages = new HashSet<Package>(this.oldPackagesByQualifiedName.values());
        obsoletePackages.removeAll(newPackages);
        for (Package obsoletePackage : obsoletePackages) {
            eContainer = obsoletePackage.eContainer();
            if (eContainer == null) continue;
            eContainmentFeature = obsoletePackage.eContainmentFeature();
            if (eContainmentFeature.isMany()) {
                siblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                siblings.remove(obsoletePackage);
                continue;
            }
            eContainer.eSet((EStructuralFeature)eContainmentFeature, null);
        }
        return true;
    }

    protected void visitContainment(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        String message;
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitContainment((ElementCS)eContent, continuations);
        }
        try {
            Continuation<?> continuation = csElement.accept(this.containmentVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (IllegalLibraryException e) {
            message = e.getMessage();
            this.addError(csElement, message, new Object[0]);
        }
        catch (Throwable e) {
            if (!this.hasFailed) {
                this.hasFailed = true;
                e.fillInStackTrace();
                logger.error((Object)("Conversion failed for '" + csElement.eClass().getName() + "'\n" + csElement), e);
                message = String.valueOf(String.valueOf(e)) + " - see error log for details";
                this.addError(csElement, message, new Object[0]);
            }
            message = String.valueOf(e);
            this.addError(csElement, message, new Object[0]);
        }
    }

    protected void visitInPostOrder(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitInPostOrder((ElementCS)eContent, continuations);
        }
        try {
            Continuation<?> continuation = csElement.accept(this.postOrderVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (Throwable e) {
            @NonNull String message = String.valueOf(e);
            this.addError(csElement, message, new Object[0]);
        }
    }

    protected void visitInPreOrder(@NonNull ElementCS csElement, @NonNull List<BasicContinuation<?>> continuations) {
        try {
            Continuation<?> continuation = csElement.accept(this.preOrderVisitor);
            if (continuation != null) {
                continuation.addTo(continuations);
            }
        }
        catch (Throwable e) {
            @NonNull String message = String.valueOf(e);
            this.addError(csElement, message, new Object[0]);
        }
        for (EObject eContent : csElement.eContents()) {
            if (!(eContent instanceof ElementCS)) continue;
            this.visitInPreOrder((ElementCS)eContent, continuations);
        }
    }

    public <T extends Element> @Nullable T visitLeft2Right(@NonNull java.lang.Class<T> pivotClass, @NonNull ElementCS csElement) {
        Element element = null;
        try {
            element = csElement.accept(this.left2RightVisitor);
        }
        catch (Throwable e) {
            @NonNull String message = String.valueOf(e);
            this.addError(csElement, message, new Object[0]);
        }
        if (element == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(element.getClass())) {
            throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = element;
        return (T)castElement;
    }

    public static class CacheKey<T> {
        protected final @NonNull String name;

        public CacheKey(@NonNull String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

