/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.ui.providers;

import java.util.Collection;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.papyrus.uml.decoratormodel.helper.IDeleteEmptyDecoratorModelsPolicy;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.preferences.ProfileExternalizationUIPreferences;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.preferences.WhenKind;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers.DecoratorModelLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeleteEmptyDecoratorModelsPolicy
implements IDeleteEmptyDecoratorModelsPolicy {
    private final IShellProvider parentShell;

    public DeleteEmptyDecoratorModelsPolicy(IShellProvider parentShell) {
        this.parentShell = parentShell;
    }

    public DeleteEmptyDecoratorModelsPolicy(Shell parentShell) {
        this((IShellProvider)new SameShellProvider((Control)parentShell));
    }

    public boolean shouldDeleteDecoratorModels(Collection<? extends Resource> decoratorModels) {
        boolean result;
        switch (ProfileExternalizationUIPreferences.getDeleteEmptyDecoratorModels()) {
            case PROMPT: {
                result = this.promptToDelete(decoratorModels);
                break;
            }
            case ALWAYS: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean promptToDelete(final Collection<? extends Resource> decoratorModels) {
        boolean result;
        MessageDialogWithToggle dlg = new MessageDialogWithToggle(this.parentShell.getShell(), Messages.DeleteEmptyDecoratorModelsPolicy_0, null, Messages.DeleteEmptyDecoratorModelsPolicy_1, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, Messages.DeleteEmptyDecoratorModelsPolicy_2, false){

            protected Control createCustomArea(Composite parent) {
                Composite custom = new Composite(parent, 0);
                custom.setLayout((Layout)new FillLayout());
                custom.setLayoutData((Object)new GridData(1808));
                TableViewer table = new TableViewer(custom, 2816);
                table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                table.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratorModelLabelProvider()));
                table.setComparator(new ViewerComparator());
                table.setInput((Object)decoratorModels);
                return custom;
            }
        };
        switch (dlg.open()) {
            case 2: {
                result = true;
                if (!dlg.getToggleState()) break;
                ProfileExternalizationUIPreferences.setDeleteEmptyDecoratorModels(WhenKind.ALWAYS);
                break;
            }
            case 3: {
                result = false;
                if (!dlg.getToggleState()) break;
                ProfileExternalizationUIPreferences.setDeleteEmptyDecoratorModels(WhenKind.NEVER);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

