/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.DuplicateViewsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.PasteViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.PasteRequest;
import org.eclipse.papyrus.uml.diagram.common.commands.PapyrusDuplicateViewsCommand;
import org.eclipse.uml2.uml.Element;

public class PasteEditPolicy
extends ContainerEditPolicy {
    public static final String PASTE_ROLE = "PASTE_ROLE";

    public Command getCommand(Request request) {
        if ("Papyrus_PASTE".equals(request.getType())) {
            if (request instanceof PasteRequest) {
                return this.getPasteCommand((PasteRequest)request);
            }
            return this.getPasteCommand((PasteViewRequest)request);
        }
        return null;
    }

    protected Command getPasteCommand(PasteRequest request) {
        ArrayList notationView = new ArrayList();
        if (request.getElementToPaste() != null && request.getElementToPaste().size() > 0) {
            notationView.addAll(request.getElementToPaste());
            HashSet semanticElement = new HashSet();
            return this.constructDuplicationCommand(notationView, semanticElement, request.getDuplicate(), ((IGraphicalEditPart)this.getHost()).getEditingDomain());
        }
        return null;
    }

    protected Command constructDuplicationCommand(List notationViewsToDuplicate, Set elementsToDuplicate, DuplicateRequest request, TransactionalEditingDomain editingDomain) {
        if (!notationViewsToDuplicate.isEmpty()) {
            if (!elementsToDuplicate.isEmpty()) {
                ArrayList stereotypedSelection = new ArrayList();
                for (EObject subeObject : elementsToDuplicate) {
                    if (!(subeObject instanceof Element)) continue;
                    stereotypedSelection.addAll(((Element)subeObject).getStereotypeApplications());
                }
                ArrayList resultToCopy = new ArrayList(elementsToDuplicate);
                resultToCopy.addAll(stereotypedSelection);
                DuplicateElementsRequest duplicateElementsRequest = new DuplicateElementsRequest(editingDomain, new ArrayList(resultToCopy));
                Command duplicateElementsCommand = this.getHost().getEditPolicy((Object)"SemanticPolicy").getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)duplicateElementsRequest, request.getExtendedData()));
                if (duplicateElementsCommand != null && duplicateElementsCommand.canExecute()) {
                    CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_Duplicate_Label);
                    cc.compose((IUndoableOperation)new CommandProxy(duplicateElementsCommand));
                    cc.compose((IUndoableOperation)new DuplicateViewsCommand(editingDomain, DiagramUIMessages.Commands_Duplicate_Label, request, notationViewsToDuplicate, duplicateElementsRequest.getAllDuplicatedElementsMap(), this.getDuplicateViewsOffset(request)));
                    return new ICommandProxy((ICommand)cc);
                }
            } else {
                return new ICommandProxy((ICommand)new PapyrusDuplicateViewsCommand(editingDomain, DiagramUIMessages.Commands_Duplicate_Label, request, notationViewsToDuplicate, new HashMap(), this.getDuplicateViewsOffset(request), (View)this.getHost().getModel()));
            }
        }
        return null;
    }

    protected Point getDuplicateViewsOffset(DuplicateRequest request) {
        if (request.getOffset() != null) {
            return request.getOffset();
        }
        int offset = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)this.getHost()).getFigure()).DPtoLP(10);
        return new Point(offset, offset);
    }
}

