/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.papyrus.uml.diagram.common.layout.EditPartRepresentation;
import org.eclipse.papyrus.uml.diagram.common.layout.SameAlignment;

public class AlignmentLinkHelper {
    private int alignment;
    private List<?> linkEditparts;
    private List<SameAlignment> families = new ArrayList<SameAlignment>();

    public AlignmentLinkHelper(List<?> editparts, int alignment) {
        this.linkEditparts = editparts;
        this.alignment = alignment;
    }

    public Command createCommand() {
        if (this.alignment == 16 || this.alignment == 2 || this.linkEditparts.size() == 0) {
            return UnexecutableCommand.INSTANCE;
        }
        this.organizeSelection();
        if (this.isAncestorSelected()) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getCommand();
    }

    protected boolean isAncestorSelected() {
        ArrayList<EditPart> nodesEditPart = new ArrayList<EditPart>();
        for (Object currentEP : this.linkEditparts) {
            EditPart source = ((AbstractConnectionEditPart)currentEP).getSource();
            EditPart target = ((AbstractConnectionEditPart)currentEP).getTarget();
            nodesEditPart.add(source);
            nodesEditPart.add(target);
        }
        for (EditPart ep : nodesEditPart) {
            if (!ToolUtilities.isAncestorContainedIn(nodesEditPart, (EditPart)ep)) continue;
            return true;
        }
        return false;
    }

    protected Command getCommand() {
        CompoundCommand cmd = new CompoundCommand("Command for alignment by links");
        for (SameAlignment currentFamily : this.families) {
            Command tmp = currentFamily.getCommand();
            if (tmp == null || !tmp.canExecute()) continue;
            cmd.add(tmp);
        }
        return cmd;
    }

    protected void organizeSelection() {
        for (Object currentEP : this.linkEditparts) {
            EditPart source = ((AbstractConnectionEditPart)currentEP).getSource();
            EditPart target = ((AbstractConnectionEditPart)currentEP).getTarget();
            SameAlignment familySource = null;
            SameAlignment familyTarget = null;
            EditPartRepresentation sourceRep = null;
            EditPartRepresentation targetRep = null;
            for (SameAlignment family : this.families) {
                if (family.getEditPartRepresentationFor(source) != null) {
                    sourceRep = family.getEditPartRepresentationFor(source);
                }
                if (family.getEditPartRepresentationFor(target) != null) {
                    targetRep = family.getEditPartRepresentationFor(target);
                }
                if (sourceRep != null) {
                    familySource = family;
                }
                if (targetRep == null) continue;
                familyTarget = family;
            }
            if (familySource != null && familyTarget != null) {
                familySource.addFamily(familyTarget);
                this.families.remove(familyTarget);
                continue;
            }
            if (familySource != null) {
                familySource.addTriplet((EditPart)currentEP, sourceRep, new EditPartRepresentation(target));
                continue;
            }
            if (familyTarget != null) {
                familyTarget.addTriplet((EditPart)currentEP, new EditPartRepresentation(source), targetRep);
                continue;
            }
            SameAlignment newFamily = new SameAlignment(this.alignment);
            newFamily.addTriplet((EditPart)currentEP, new EditPartRepresentation(source), new EditPartRepresentation(target));
            this.families.add(newFamily);
        }
    }
}

