/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.etfw.feedback.IFeedbackItem;
import org.eclipse.ptp.etfw.feedback.IFeedbackParser;
import org.eclipse.ptp.internal.etfw.feedback.MarkerManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeedbackParser
implements IFeedbackParser {
    private MarkerManager mkrMgr;

    @Override
    public void createMarkers(List<IFeedbackItem> items, String markerID) {
        if (this.mkrMgr == null) {
            this.mkrMgr = new MarkerManager();
        }
        this.mkrMgr.createMarkers(items, markerID);
    }

    public IFile findSourceFile(String filename, IFile xmlSourceFile) {
        IFile f2 = (IFile)this.getResourceInProject(xmlSourceFile.getProject(), filename);
        return f2;
    }

    public IResource getResourceInProject(IProject proj, String filename) {
        IResource res = proj.findMember(filename);
        return res;
    }

    public IResource getResourceInProject(String projName, String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject proj = root.getProject(projName);
        IResource res = proj.findMember(filename);
        res.exists();
        return res;
    }

    public Document getXMLDocument(IFile file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document document = null;
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        InputStream xmlIn = null;
        try {
            xmlIn = file.getContents();
            document = builder.parse(xmlIn);
        }
        catch (CoreException e1) {
            System.out.println("CoreException getting inputstream from: " + file);
            e1.printStackTrace();
            document = null;
        }
        return document;
    }
}

