/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.trigger;

import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.trigger.AbstractDerivedResourceHandler;

public abstract class AbstractDerivedResourceSingleHandler
extends AbstractDerivedResourceHandler {
    private final IJavaEnvironmentProvider m_envProvider;
    private final IType m_jdtType;
    private final org.eclipse.scout.sdk.core.model.api.IType m_modelType;

    protected AbstractDerivedResourceSingleHandler(IType jdtType, IJavaEnvironmentProvider envProvider) {
        this.m_jdtType = (IType)Validate.notNull((Object)jdtType);
        this.m_envProvider = envProvider;
        this.m_modelType = this.m_envProvider.jdtTypeToScoutType(jdtType);
    }

    protected final IType getJdtType() {
        return this.m_jdtType;
    }

    protected final IJavaEnvironmentProvider getJavaEnvironmentProvider() {
        return this.m_envProvider;
    }

    protected String getModelFullyQualifiedName() {
        return this.m_jdtType.getFullyQualifiedName();
    }

    protected final org.eclipse.scout.sdk.core.model.api.IType getModelType() {
        return this.m_modelType;
    }

    @Override
    public void validate() {
        if (this.m_jdtType == null) {
            throw new IllegalArgumentException("jdt type must exist.");
        }
        if (this.m_modelType == null) {
            throw new IllegalArgumentException("model type must exist: [" + this.getModelFullyQualifiedName() + "].");
        }
    }

    public int hashCode() {
        if (this.m_modelType == null) {
            return 0;
        }
        return this.m_modelType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.m_jdtType.equals(((AbstractDerivedResourceSingleHandler)obj).m_jdtType);
    }
}

