/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class ImportProjectSetOperation
extends TeamOperation {
    private String psfFileContents;
    private String urlString;
    private String psfFile;
    private IWorkingSet[] workingSets;

    public ImportProjectSetOperation(IRunnableContext context, String psfFileContents, String urlString, IWorkingSet[] workingSets) {
        super(context);
        this.psfFileContents = psfFileContents;
        this.workingSets = workingSets;
        this.urlString = urlString;
    }

    public ImportProjectSetOperation(IRunnableContext context, String psfFile, IWorkingSet[] workingSets) {
        super(context);
        this.psfFile = psfFile;
        this.workingSets = workingSets;
    }

    private void runForStringContent(IProgressMonitor monitor) throws InvocationTargetException {
        IProject[] newProjects = ProjectSetImporter.importProjectSetFromString(this.psfFileContents, this.urlString, this.getShell(), monitor);
        this.createWorkingSet(this.workingSets, newProjects);
    }

    private void runForFile(IProgressMonitor monitor) throws InvocationTargetException {
        PsfFilenameStore.getInstance().remember(this.psfFile);
        IProject[] newProjects = ProjectSetImporter.importProjectSet(this.psfFile, this.getShell(), monitor);
        this.createWorkingSet(this.workingSets, newProjects);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.psfFileContents != null) {
            this.runForStringContent(monitor);
        } else {
            this.runForFile(monitor);
        }
    }

    @Override
    protected boolean canRunAsJob() {
        return true;
    }

    @Override
    protected String getJobName() {
        return TeamUIMessages.ImportProjectSetMainPage_jobName;
    }

    private void createWorkingSet(IWorkingSet[] workingSets, IProject[] projects) {
        IWorkingSetManager manager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            String workingSetName = workingSet.getName();
            IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
            if (oldSet == null) {
                IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
                manager.addWorkingSet(newSet);
            } else {
                IAdaptable[] tempElements = oldSet.getElements();
                IAdaptable[] adaptedProjects = oldSet.adaptElements((IAdaptable[])projects);
                IAdaptable[] finalElementList = new IAdaptable[tempElements.length + adaptedProjects.length];
                System.arraycopy(tempElements, 0, finalElementList, 0, tempElements.length);
                System.arraycopy(adaptedProjects, 0, finalElementList, tempElements.length, adaptedProjects.length);
                oldSet.setElements(finalElementList);
            }
            ++n2;
        }
    }
}

