/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenSourceCodeAction
extends Action {
    private static final String EMPTY_STRING = "";
    private final ITmfCallsite fCallsite;
    private final Shell fShell;

    public static IContributionItem create(String actionText, ITmfSourceLookup sourceLookup, Shell shell) {
        List cs = sourceLookup.getCallsites();
        if (cs == null) {
            return null;
        }
        List callsites = cs.stream().filter(callstack -> callstack.getLineNo() != null).collect(Collectors.toList());
        if (callsites.isEmpty()) {
            return null;
        }
        if (callsites.size() == 1) {
            return new ActionContributionItem((IAction)new OpenSourceCodeAction(actionText, (ITmfCallsite)callsites.get(0), shell));
        }
        MenuManager mgr = new MenuManager(actionText);
        for (ITmfCallsite callsite : callsites) {
            mgr.add((IAction)new OpenSourceCodeAction(callsite.toString(), callsite, shell));
        }
        return mgr;
    }

    private OpenSourceCodeAction(String text, ITmfCallsite callsite, Shell shell) {
        super(text);
        this.fCallsite = callsite;
        this.fShell = shell;
    }

    public void run() {
        ITmfCallsite cs = this.fCallsite;
        if (cs == null) {
            return;
        }
        String fileName = cs.getFileName();
        Long lineNo = cs.getLineNo();
        if (lineNo == null) {
            return;
        }
        String trimmedPath = fileName.replaceAll("\\.\\./", EMPTY_STRING);
        File fileToOpen = new File(trimmedPath);
        try {
            if (fileToOpen.exists() && fileToOpen.isFile()) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                if (editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    int lineNumber = lineNo.intValue();
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    IRegion region = document.getLineInformation(lineNumber - 1);
                    if (region != null) {
                        textEditor.selectAndReveal(region.getOffset(), region.getLength());
                    }
                }
            } else {
                IMarker marker = null;
                ArrayList files = new ArrayList();
                Path p = new Path(trimmedPath);
                ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor((IPath)p, files){
                    private final /* synthetic */ IPath val$p;
                    private final /* synthetic */ ArrayList val$files;
                    {
                        this.val$p = iPath;
                        this.val$files = arrayList;
                    }

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile && resource.getFullPath().toString().endsWith(this.val$p.lastSegment())) {
                            this.val$files.add((IFile)resource);
                        }
                        return true;
                    }
                });
                IFile file = null;
                if (files.size() > 1) {
                    ListDialog dialog = new ListDialog(this.fShell);
                    dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            return ((IFile)element).getFullPath().toString();
                        }
                    });
                    dialog.setInput(files);
                    dialog.setTitle(Messages.TmfSourceLookup_OpenSourceCodeSelectFileDialogTitle);
                    dialog.setMessage(String.valueOf(Messages.TmfSourceLookup_OpenSourceCodeSelectFileDialogTitle) + '\n' + cs.toString());
                    dialog.open();
                    Object[] result = dialog.getResult();
                    if (result != null && result.length > 0) {
                        file = (IFile)result[0];
                    }
                } else if (files.size() == 1) {
                    file = (IFile)files.get(0);
                }
                if (file != null) {
                    marker = file.createMarker("org.eclipse.core.resources.marker");
                    marker.setAttribute("lineNumber", lineNo.intValue());
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
                    marker.delete();
                } else if (files.isEmpty()) {
                    TraceUtils.displayWarningMsg(new FileNotFoundException(String.valueOf('\'') + cs.toString() + '\'' + '\n' + Messages.TmfSourceLookup_OpenSourceCodeNotFound));
                }
            }
        }
        catch (CoreException | BadLocationException e) {
            TraceUtils.displayErrorMsg(e);
        }
    }
}

